/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class CraftingLeather
extends SimpleAdaptation<Config> {
    public CraftingLeather() {
        super("crafting-leather");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "leather", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "leather", "name"));
        this.setIcon(Material.LEATHER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(17776L);
        this.registerRecipe(AdaptRecipe.campfire().key("crafting-leather").ingredient(Material.ROTTEN_FLESH).cookTime(100).experience(1.0f).result(new ItemStack(Material.LEATHER, 1)).build());
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("crafting", "leather", "lore1"));
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        if (e.getItem() != null && e.getItem().getType() == Material.ROTTEN_FLESH && e.getClickedBlock() != null && e.getClickedBlock().getType() == Material.CAMPFIRE && !this.hasAdaptation(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = true;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 1;
        int initialCost = 2;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

