/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DiscoveryArmor
extends SimpleAdaptation<Config> {
    public DiscoveryArmor() {
        super("discovery-world-armor");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "armor", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "armor", "name"));
        this.setIcon(Material.TURTLE_HELMET);
        this.setInterval(1305L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Localizer.dLocalize("discovery", "armor", "lore1") + C.GRAY + ", " + Localizer.dLocalize("discovery", "armor", "lore2"));
        v.addLore(C.YELLOW + "~ " + Localizer.dLocalize("discovery", "armor", "lore3") + C.BLUE + " +" + (double)level * 0.25);
    }

    public double getArmorPoints(Material m) {
        return Math.log(Math.min(2000.0f, m.getBlastResistance() * m.getBlastResistance())) + Math.log((double)(m.getHardness() < 0.0f ? 50.0f : Math.min(50.0f, m.getHardness() + 25.0f)) * 0.33);
    }

    public double getArmor(Location l, int level) {
        Block center = l.getBlock();
        double armorValue = 0.0;
        double count = 0.0;
        int r = 5;
        for (int x = -r; x <= r; ++x) {
            for (int y = -r; y <= r; ++y) {
                for (int z = -r; z <= r; ++z) {
                    Block b = center.getRelative(x, y, z);
                    if (!(center.getLocation().distanceSquared(b.getLocation()) <= (double)(r * r)) || b.getType() == Material.AIR || b.isLiquid()) continue;
                    count += 1.0;
                    double a = this.getArmorPoints(b.getType());
                    if (Double.isNaN(a) || a < 0.0) {
                        a = 0.0;
                    }
                    armorValue += a;
                    if (!(a > 2.0) || !M.r(0.005 * a)) continue;
                    Vector v = VectorMath.directionNoNormal(l, b.getLocation().add(0.5, 0.5, 0.5));
                    if (!((Config)this.getConfig()).showParticles) continue;
                    l.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, l.clone().add(0.0, 1.0, 0.0), 0, v.getX(), v.getY(), v.getZ());
                }
            }
        }
        return Math.min(armorValue / count * ((double)level / 2.0) * 0.65, 10.0);
    }

    private double getRadius(double factor) {
        return factor * (double)((Config)this.getConfig()).radiusFactor;
    }

    private double getStrength(double factor) {
        return Math.pow(factor, ((Config)this.getConfig()).strengthExponent);
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p == null || !p.isOnline()) continue;
            if (!this.hasAdaptation(p)) {
                Collection c = p.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
                for (AttributeModifier i : new ArrayList(c)) {
                    if (!i.getName().equals("adapt-discovery-armor")) continue;
                    p.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(i);
                }
                continue;
            }
            double oldArmor = 0.0;
            double armor = this.getArmor(p.getLocation(), this.getLevel(p));
            armor = Double.isNaN(armor) ? 0.0 : armor;
            Collection c = p.getAttribute(Attribute.GENERIC_ARMOR).getModifiers();
            for (AttributeModifier i : new ArrayList(c)) {
                if (!i.getName().equals("adapt-discovery-armor")) continue;
                oldArmor = i.getAmount();
                oldArmor = Double.isNaN(oldArmor) ? 0.0 : oldArmor;
                p.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(i);
            }
            double lArmor = M.lerp(oldArmor, armor, 0.3);
            lArmor = Double.isNaN(lArmor) ? 0.0 : lArmor;
            p.getAttribute(Attribute.GENERIC_ARMOR).addModifier(new AttributeModifier("adapt-discovery-armor", lArmor, AttributeModifier.Operation.ADD_NUMBER));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int radiusFactor = 3;
        public double strengthExponent = 1.25;
        public boolean showParticles = true;
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

