/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;

public class DiscoveryXpResist
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public DiscoveryXpResist() {
        super("discovery-xp-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "resist", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "resist", "name"));
        this.setIcon(Material.EMERALD);
        this.setInterval(5215L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore0"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(level)), 0) + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore1"));
        v.addLore(C.GREEN + "+ " + this.getXpTaken(level) + " " + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore2"));
    }

    private double getEffectiveness(double factor) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, factor * factor + ((Config)this.getConfig()).effectivenessBase);
    }

    private int getXpTaken(double level) {
        double d = (double)((Config)this.getConfig()).levelCostAdd * ((Config)this.getConfig()).amplifier - level * (double)((Config)this.getConfig()).levelDrain;
        return (int)d;
    }

    @EventHandler
    public void on(EntityDamageEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity) && p.getLevel() > 1) {
            if (p.getLevel() < p.getLevel() - this.getXpTaken(this.getLevel(p))) {
                this.vfxFastRing(p.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                p.playSound(p.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
                return;
            }
            if (!this.cooldowns.containsKey(p) || this.cooldowns.containsKey(p) && M.ms() - this.cooldowns.get(p) > 15000L) {
                e.setDamage(e.getDamage() - e.getDamage() * this.getEffectiveness(this.getLevelPercent(this.getLevel(p))));
                this.xp(p, 5.0);
                this.cooldowns.put(p, M.ms());
                if (p.getLevel() - this.getXpTaken(this.getLevel(p)) > 0) {
                    p.setLevel(p.getLevel() - this.getXpTaken(this.getLevel(p)));
                    this.vfxFastRing(p.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.LIME);
                    p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_REPAIR, 3.0f, 0.01f);
                    p.playSound(p.getLocation(), Sound.BLOCK_SHROOMLIGHT_HIT, 15.0f, 0.01f);
                } else {
                    this.vfxFastRing(p.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                    p.playSound(p.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
                }
            } else {
                this.vfxFastRing(p.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                p.playSound(p.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int initialCost = 3;
        double costFactor = 0.8;
        int maxLevel = 5;
        double effectivenessBase = 0.15;
        double maxEffectiveness = 0.95;
        int levelDrain = 2;
        int levelCostAdd = 12;
        double amplifier = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

