/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.enchanting;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantingQuickEnchant
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public EnchantingQuickEnchant() {
        super("enchanting-quick-enchant");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("enchanting", "quickenchant", "description"));
        this.setDisplayName(Localizer.dLocalize("enchanting", "quickenchant", "name"));
        this.setIcon(Material.WRITABLE_BOOK);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(15100L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    private int getTotalLevelCount(int level) {
        return level + (level > ((Config)this.getConfig()).maxPowerBonusLimit ? level / ((Config)this.getConfig()).maxPowerBonus1PerLevels : 0);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + this.getTotalLevelCount(level) + C.GRAY + " " + Localizer.dLocalize("enchanting", "quickenchant", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        Player p;
        if (e.getClickedInventory() == null || e.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player && this.hasAdaptation(p = (Player)humanEntity) && e.getAction().equals((Object)InventoryAction.SWAP_WITH_CURSOR) && e.getClick().equals((Object)ClickType.LEFT) && (e.getSlotType().equals((Object)InventoryType.SlotType.CONTAINER) || e.getSlotType().equals((Object)InventoryType.SlotType.ARMOR) || e.getSlotType().equals((Object)InventoryType.SlotType.QUICKBAR)) && e.getCursor() != null && e.getCurrentItem() != null && e.getCursor().getType().equals((Object)Material.ENCHANTED_BOOK) && !e.getCurrentItem().getType().equals((Object)Material.BOOK) && !e.getCurrentItem().getType().equals((Object)Material.ENCHANTED_BOOK) && e.getCursor().getItemMeta() != null && (humanEntity = e.getCursor().getItemMeta()) instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta eb = (EnchantmentStorageMeta)humanEntity;
            if (e.getCurrentItem().getItemMeta() != null && e.getCurrentItem().getAmount() == 1 && e.getCursor().getAmount() == 1) {
                ItemStack item = e.getCurrentItem();
                ItemStack book = e.getCursor();
                HashMap itemEnchants = new HashMap(item.getType().equals((Object)Material.ENCHANTED_BOOK) ? ((EnchantmentStorageMeta)item.getItemMeta()).getStoredEnchants() : item.getEnchantments());
                HashMap<Enchantment, Integer> bookEnchants = new HashMap<Enchantment, Integer>(eb.getStoredEnchants());
                Map<Enchantment, Integer> newEnchants = XMap.copy(itemEnchants);
                HashMap<Enchantment, Integer> addEnchants = new HashMap<Enchantment, Integer>();
                int power = itemEnchants.values().stream().mapToInt(i -> i).sum();
                if (bookEnchants.isEmpty()) {
                    return;
                }
                for (Enchantment i2 : XMap.k(bookEnchants)) {
                    if (itemEnchants.containsKey(i2)) continue;
                    power += ((Integer)bookEnchants.get(i2)).intValue();
                    newEnchants.put(i2, (Integer)bookEnchants.get(i2));
                    addEnchants.put(i2, (Integer)bookEnchants.get(i2));
                    bookEnchants.remove(i2);
                }
                if (power > this.getTotalLevelCount(this.getLevel(p))) {
                    Adapt.actionbar(p, C.RED + Localizer.dLocalize("enchanting", "quickenchant", "lore2") + this.getTotalLevelCount(this.getLevel(p)) + " " + Localizer.dLocalize("enchanting", "quickenchant", "lore3"));
                    p.playSound(p.getLocation(), Sound.BLOCK_CONDUIT_DEACTIVATE, 0.5f, 1.7f);
                    return;
                }
                if (!itemEnchants.equals(newEnchants)) {
                    ItemMeta im = item.getItemMeta();
                    if (im instanceof EnchantmentStorageMeta) {
                        EnchantmentStorageMeta sm = (EnchantmentStorageMeta)im;
                        sm.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)sm).removeStoredEnchant(arg_0));
                        newEnchants.forEach((ec, l) -> sm.addStoredEnchant(ec, l.intValue(), true));
                        Adapt.messagePlayer(p, "---");
                        sm.getStoredEnchants().forEach((k, v) -> Adapt.messagePlayer(p, k.getKey().getKey() + " " + v));
                    } else {
                        im.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)im).removeEnchant(arg_0));
                        newEnchants.forEach((ec, l) -> im.addEnchant(ec, l.intValue(), true));
                    }
                    this.xp(p, 50.0);
                    item.setItemMeta(im);
                    e.setCurrentItem(item);
                    e.setCancelled(true);
                    p.playSound(p.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.7f);
                    p.playSound(p.getLocation(), Sound.BLOCK_DEEPSLATE_TILES_BREAK, 0.5f, 0.7f);
                    this.getSkill().xp(p, 320 * addEnchants.values().stream().mapToInt(i -> i).sum());
                    if (bookEnchants.isEmpty()) {
                        e.setCursor(null);
                    } else if (!eb.getStoredEnchants().equals(bookEnchants)) {
                        eb.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)eb).removeStoredEnchant(arg_0));
                        bookEnchants.forEach((ec, l) -> eb.addStoredEnchant(ec, l.intValue(), true));
                        book.setItemMeta((ItemMeta)eb);
                        e.setCursor(book);
                    }
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 7;
        int initialCost = 8;
        double costFactor = 1.355;
        int maxPowerBonusLimit = 4;
        int maxPowerBonus1PerLevels = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

