/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.enchanting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class EnchantingXPReturn
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldown = new HashMap<Player, Long>();

    public EnchantingXPReturn() {
        super("enchanting-xp-return");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("enchanting", "return", "description"));
        this.setDisplayName(Localizer.dLocalize("enchanting", "return", "name"));
        this.setIcon(Material.EXPERIENCE_BOTTLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(13001L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("enchanting", "return", "lore1"));
        v.addLore(C.GREEN + ((Config)this.getConfig()).xpReturn * (level * level) + Localizer.dLocalize("enchanting", "return", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.cooldown.remove(p);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EnchantItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        int level = this.getLevel(e.getEnchanter());
        Player p = e.getEnchanter();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (this.cooldown.containsKey(p) && this.cooldown.get(p) + 20000L < System.currentTimeMillis()) {
            this.cooldown.remove(p);
        } else if (this.cooldown.containsKey(p) && this.cooldown.get(p) + 20000L > System.currentTimeMillis()) {
            return;
        }
        this.cooldown.put(p, System.currentTimeMillis());
        ((ExperienceOrb)p.getWorld().spawn(p.getLocation(), ExperienceOrb.class)).setExperience(((Config)this.getConfig()).xpReturn * (level * level));
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int xpReturn = 2;
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int maxLevel = 7;
        int initialCost = 2;
        double costFactor = 1.97;

        static {
            IBootstrap.dasBoot();
        }
    }
}

