/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class ExcavationDropToInventory
extends SimpleAdaptation<Config> {
    public ExcavationDropToInventory() {
        super("excavation-drop-to-inventory");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "droptoinventory", "description"));
        this.setDisplayName(Localizer.dLocalize("excavation", "droptoinventory", "name"));
        this.setIcon(Material.DIRT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(11777L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("pickaxe", "droptoinventory", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockDropItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (p.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (ItemListings.toolShovels.contains(p.getInventory().getItemInMainHand().getType())) {
            List<Item> items = XList.copy(e.getItems());
            e.getItems().clear();
            for (Item i : items) {
                p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
                this.xp(p, 2.0);
                if (p.getInventory().addItem(new ItemStack[]{i.getItemStack()}).isEmpty()) continue;
                p.getWorld().dropItem(p.getLocation(), i.getItemStack());
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int maxLevel = 1;
        int initialCost = 3;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

