/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.nms.GlowingEntities;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ExcavationSpelunker
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public ExcavationSpelunker() {
        super("excavation-spelunker");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("excavation", "spelunker", "name"));
        this.setDescription(Localizer.dLocalize("excavation", "spelunker", "description"));
        this.setIcon(Material.GOLDEN_HELMET);
        this.setInterval(20388L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("excavation", "spelunker", "lore1"));
        v.addLore(C.YELLOW + Localizer.dLocalize("excavation", "spelunker", "lore2") + ((Config)this.getConfig()).rangeMultiplier * level);
        v.addLore(C.YELLOW + Localizer.dLocalize("excavation", "spelunker", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (p.isSneaking() && this.hasGlowberries(p) && this.hasOreInOffhand(p) && this.hasAdaptation(p)) {
            if (this.cooldowns.containsKey(p) && this.cooldowns.get(p).compareTo(System.currentTimeMillis()) > 0) {
                p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                return;
            }
            int radius = ((Config)this.getConfig()).rangeMultiplier * this.getLevel(p);
            this.consumeGlowberry(p);
            this.searchForOres(p, radius);
            this.cooldowns.put(p, (long)((double)System.currentTimeMillis() + 1000.0 * ((Config)this.getConfig()).cooldown));
        }
    }

    private boolean hasGlowberries(Player player) {
        return player.getInventory().getItemInMainHand().getType() == Material.GLOW_BERRIES;
    }

    private void consumeGlowberry(Player player) {
        ItemStack berries = player.getInventory().getItemInMainHand();
        berries.setAmount(berries.getAmount() - 1);
        player.getInventory().setItemInMainHand(berries);
    }

    private boolean hasOreInOffhand(Player player) {
        Material offhandType = player.getInventory().getItemInOffHand().getType();
        return ItemListings.ores.contains(offhandType);
    }

    private void searchForOres(Player p, int radius) {
        Location playerLocation = p.getLocation();
        World world = p.getWorld();
        Material targetOre = p.getInventory().getItemInOffHand().getType();
        ChatColor c = ItemListings.oreColorsChatColor.get(targetOre);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.WHITE, 1.0f);
        J.a(() -> {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        Location blockLocation = playerLocation.clone().add((double)x, (double)y, (double)z);
                        Block block = world.getBlockAt(blockLocation);
                        GlowingEntities glowingEntities = Adapt.instance.getGlowingEntities();
                        if (block.getType() != targetOre) continue;
                        Vector vector = blockLocation.clone().subtract(playerLocation).toVector().normalize().multiply(0.5);
                        Location particleLocation = playerLocation.clone();
                        while (particleLocation.distance(blockLocation) > 0.5) {
                            particleLocation.add(vector);
                            J.s(() -> p.spawnParticle(Particle.REDSTONE, particleLocation, 1, (Object)dustOptions));
                        }
                        J.s(() -> {
                            world.playSound(block.getLocation().add(0.5, 0.0, 0.5), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                            Slime slime = (Slime)block.getWorld().spawn(block.getLocation().add(0.5, 0.0, 0.5), Slime.class, s -> {
                                s.setRotation(0.0f, 0.0f);
                                s.setInvulnerable(true);
                                s.setCollidable(false);
                                s.setGravity(false);
                                s.setSilent(true);
                                s.setAI(false);
                                s.setSize(2);
                                s.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
                                s.setMetadata("preventSuffocation", (MetadataValue)new FixedMetadataValue((Plugin)Adapt.instance, (Object)true));
                            });
                            try {
                                glowingEntities.setGlowing((Entity)slime, p, c);
                            }
                            catch (ReflectiveOperationException e) {
                                throw new RuntimeException(e);
                            }
                            J.s(() -> {
                                try {
                                    glowingEntities.unsetGlowing((Entity)slime, p);
                                }
                                catch (ReflectiveOperationException e) {
                                    throw new RuntimeException(e);
                                }
                                slime.remove();
                            }, 100);
                        });
                    }
                }
            }
        });
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Slime && e.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            Slime slime = (Slime)e.getEntity();
            if (slime.hasMetadata("preventSuffocation")) {
                e.setCancelled(true);
            } else {
                e.setCancelled(true);
                slime.remove();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        double cooldown = 6.0;
        int baseCost = 5;
        int initialCost = 10;
        double costFactor = 1.0;
        int maxLevel = 5;
        int rangeMultiplier = 5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

