/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class HerbalismGrowthAura
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public HerbalismGrowthAura() {
        super("herbalism-growth-aura");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "growthaura", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "growthaura", "name"));
        this.setIcon(Material.BONE_MEAL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(850L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.f(this.getRadius(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore1"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getStrength(level), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore2"));
        v.addLore(C.YELLOW + "+ " + Form.f(this.getFoodCost(this.getLevelPercent(level)), 2) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore3"));
    }

    private double getRadius(double factor) {
        return factor * ((Config)this.getConfig()).radiusFactor;
    }

    private double getStrength(int level) {
        return (double)level * ((Config)this.getConfig()).strengthFactor;
    }

    private double getFoodCost(double factor) {
        return M.lerp(1.0 - factor, ((Config)this.getConfig()).maxFoodCost, ((Config)this.getConfig()).minFoodCost);
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            try {
                if (!this.hasAdaptation(p)) continue;
                double rad = this.getRadius(this.getLevelPercent(p));
                double strength = this.getStrength(this.getLevel(p));
                double angle = Math.toRadians(Math.random() * 360.0);
                double foodCost = this.getFoodCost(this.getLevelPercent(p));
                int i = 0;
                while ((double)i < Math.min(Math.min(rad * rad, 256.0), 3.0)) {
                    Ageable ab;
                    int toGrowLeft;
                    Location m = p.getLocation().clone().add(new Vector(Math.sin(angle), (double)RNG.r.i(-1, 1), Math.cos(angle)).multiply(Math.random() * rad));
                    Block a = m.getWorld().getHighestBlockAt(m).getRelative(BlockFace.UP);
                    if (a.getBlockData() instanceof Ageable && (toGrowLeft = (ab = (Ageable)a.getBlockData()).getMaximumAge() - ab.getAge()) > 0) {
                        int add = (int)Math.max(1.0, Math.min(strength, (double)toGrowLeft));
                        if (ab.getMaximumAge() > ab.getAge() && this.getPlayer(p).canConsumeFood(foodCost, 10)) {
                            while (add-- > 0) {
                                J.s(() -> {
                                    Ageable aab;
                                    if (this.getPlayer(p).consumeFood(foodCost, 10) && a.getBlockData() instanceof Ageable && (aab = (Ageable)a.getBlockData()).getAge() < aab.getMaximumAge()) {
                                        aab.setAge(aab.getAge() + 1);
                                        a.setBlockData((BlockData)aab, true);
                                        a.getWorld().playSound(a.getLocation(), Sound.BLOCK_CHORUS_FLOWER_DEATH, 0.25f, RNG.r.f(0.3f, 0.7f));
                                        if (((Config)this.getConfig()).showParticles) {
                                            p.spawnParticle(Particle.VILLAGER_HAPPY, a.getLocation().clone().add(0.5, 0.5, 0.5), 3, 0.3, 0.3, 0.3, 0.9);
                                        }
                                    }
                                }, RNG.r.i(30, 60));
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 8;
        int maxLevel = 7;
        int initialCost = 12;
        double costFactor = 0.325;
        double minFoodCost = 0.05;
        double maxFoodCost = 0.4;
        double radiusFactor = 18.0;
        double strengthFactor = 0.75;

        static {
            IBootstrap.dasBoot();
        }
    }
}

