/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class HunterAdrenaline
extends SimpleAdaptation<Config> {
    public HunterAdrenaline() {
        super("hunter-adrenaline");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "adrenaline", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "adrenaline", "name"));
        this.setIcon(Material.LEATHER_HELMET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(1911L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getDamage(level), 0) + C.GRAY + " " + Localizer.dLocalize("hunter", "adrenaline", "lore1"));
    }

    private double getDamage(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).damageFactor + ((Config)this.getConfig()).damageBase;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity) && this.getLevel((Player)e.getDamager()) > 0) {
            double damageMax = this.getDamage(this.getLevel(p));
            double hpp = ((Player)e.getDamager()).getHealth() / ((Player)e.getDamager()).getMaxHealth();
            if (hpp >= 1.0) {
                return;
            }
            e.setDamage(e.getDamage() * ((damageMax *= 1.0 - hpp) + 1.0));
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 4;
        int maxLevel = 5;
        int initialCost = 8;
        double costFactor = 0.4;
        double damageBase = 0.12;
        double damageFactor = 0.21;

        static {
            IBootstrap.dasBoot();
        }
    }
}

