/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class HunterStrength
extends SimpleAdaptation<Config> {
    public HunterStrength() {
        super("hunter-strength");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "strength", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "strength", "name"));
        this.setIcon(Material.COD_BUCKET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(9044L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("hunter", "strength", "lore1"));
        v.addLore(C.GREEN + "+ " + level + C.GRAY + Localizer.dLocalize("hunter", "strength", "lore2"));
        v.addLore(C.RED + "- " + (5 + level) + C.GRAY + Localizer.dLocalize("hunter", "strength", "lore3"));
        v.addLore(C.GRAY + "* " + level + C.GRAY + " " + Localizer.dLocalize("hunter", "strength", "lore4"));
        v.addLore(C.GRAY + "* " + level + C.GRAY + " " + Localizer.dLocalize("hunter", "strength", "lore5"));
        v.addLore(C.GRAY + "- " + level + C.RED + " " + Localizer.dLocalize("hunter", "penalty", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (this.isAdaptableDamageCause(e) && this.hasAdaptation(p)) {
                if (AdaptConfig.get().isPreventHunterSkillsWhenHungerApplied() && p.hasPotionEffect(PotionEffectType.HUNGER)) {
                    return;
                }
                if (!((Config)this.getConfig()).useConsumable) {
                    if (p.getFoodLevel() == 0) {
                        if (((Config)this.getConfig()).poisonPenalty) {
                            this.addPotionStacks(p, PotionEffectType.POISON, ((Config)this.getConfig()).basePoisonFromLevel - this.getLevel(p), ((Config)this.getConfig()).baseHungerDuration, ((Config)this.getConfig()).stackPoisonPenalty);
                        }
                    } else {
                        this.addPotionStacks(p, PotionEffectType.HUNGER, ((Config)this.getConfig()).baseHungerFromLevel - this.getLevel(p), ((Config)this.getConfig()).baseHungerDuration * this.getLevel(p), ((Config)this.getConfig()).stackHungerPenalty);
                        this.addPotionStacks(p, PotionEffectType.INCREASE_DAMAGE, this.getLevel(p), ((Config)this.getConfig()).baseEffectbyLevel * this.getLevel(p), ((Config)this.getConfig()).stackBuff);
                    }
                } else if (((Config)this.getConfig()).consumable != null && Material.getMaterial((String)((Config)this.getConfig()).consumable) != null) {
                    Material mat = Material.getMaterial((String)((Config)this.getConfig()).consumable);
                    if (mat != null && p.getInventory().contains(mat)) {
                        p.getInventory().removeItem(new ItemStack[]{new ItemStack(mat, 1)});
                        this.addPotionStacks(p, PotionEffectType.INCREASE_DAMAGE, this.getLevel(p), ((Config)this.getConfig()).baseEffectbyLevel * this.getLevel(p), ((Config)this.getConfig()).stackBuff);
                    } else if (((Config)this.getConfig()).poisonPenalty) {
                        this.addPotionStacks(p, PotionEffectType.POISON, ((Config)this.getConfig()).basePoisonFromLevel - this.getLevel(p), ((Config)this.getConfig()).baseHungerDuration, ((Config)this.getConfig()).stackPoisonPenalty);
                    }
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean useConsumable = false;
        boolean poisonPenalty = true;
        boolean stackHungerPenalty = false;
        boolean stackPoisonPenalty = false;
        boolean stackBuff = false;
        int baseEffectbyLevel = 25;
        int baseHungerFromLevel = 10;
        int basePoisonFromLevel = 6;
        int baseHungerDuration = 50;
        String consumable = "ROTTEN_FLESH";
        int baseCost = 4;
        int maxLevel = 5;
        int initialCost = 8;
        double costFactor = 0.4;

        static {
            IBootstrap.dasBoot();
        }
    }
}

