/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;

public class NetherFireResist
extends SimpleAdaptation<Config> {
    private final Random random = new Random();

    public NetherFireResist() {
        super("nether-fire-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "fireresist", "description"));
        this.setDisplayName(Localizer.dLocalize("nether", "fireresist", "name"));
        this.setIcon(Material.BLAZE_POWDER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4333L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.RED + "+ " + Form.pc(this.getFireResist(level), 0) + C.GRAY + " " + Localizer.dLocalize("nether", "fireresist", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (e.getCause() != EntityDamageEvent.DamageCause.FIRE && e.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        if (this.random.nextDouble() < this.getFireResist(this.getLevel(p))) {
            e.setCancelled(true);
        }
    }

    public double getFireResist(double level) {
        return ((Config)this.getConfig()).fireResistBase + ((Config)this.getConfig()).fireResistFactor * level;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 4;
        double costFactor = 0.75;
        int maxLevel = 3;
        int initialCost = 6;
        double fireResistBase = 0.1;
        double fireResistFactor = 0.25;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public double getFireResistBase() {
            return this.fireResistBase;
        }

        public double getFireResistFactor() {
            return this.fireResistFactor;
        }

        public void setPermanent(boolean permanent) {
            this.permanent = permanent;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setBaseCost(int baseCost) {
            this.baseCost = baseCost;
        }

        public void setCostFactor(double costFactor) {
            this.costFactor = costFactor;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public void setInitialCost(int initialCost) {
            this.initialCost = initialCost;
        }

        public void setFireResistBase(double fireResistBase) {
            this.fireResistBase = fireResistBase;
        }

        public void setFireResistFactor(double fireResistFactor) {
            this.fireResistFactor = fireResistFactor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != other.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getBaseCost() != other.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), other.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != other.getMaxLevel()) {
                return false;
            }
            if (this.getInitialCost() != other.getInitialCost()) {
                return false;
            }
            if (Double.compare(this.getFireResistBase(), other.getFireResistBase()) != 0) {
                return false;
            }
            return Double.compare(this.getFireResistFactor(), other.getFireResistFactor()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPermanent() ? 79 : 97);
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getBaseCost();
            long $costFactor = Double.doubleToLongBits(this.getCostFactor());
            result = result * 59 + (int)($costFactor >>> 32 ^ $costFactor);
            result = result * 59 + this.getMaxLevel();
            result = result * 59 + this.getInitialCost();
            long $fireResistBase = Double.doubleToLongBits(this.getFireResistBase());
            result = result * 59 + (int)($fireResistBase >>> 32 ^ $fireResistBase);
            long $fireResistFactor = Double.doubleToLongBits(this.getFireResistFactor());
            result = result * 59 + (int)($fireResistFactor >>> 32 ^ $fireResistFactor);
            return result;
        }

        public String toString() {
            return "NetherFireResist.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", fireResistBase=" + this.getFireResistBase() + ", fireResistFactor=" + this.getFireResistFactor() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

