/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class NetherSkullYeet
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> lastJump = new HashMap<Player, Long>();

    public NetherSkullYeet() {
        super("nether-skull-toss");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "skulltoss", "description1") + C.ITALIC + " " + Localizer.dLocalize("nether", "skulltoss", "description2") + " " + C.GRAY + Localizer.dLocalize("nether", "skulltoss", "description3"));
        this.setDisplayName(Localizer.dLocalize("nether", "skulltoss", "name"));
        this.setIcon(Material.WITHER_SKELETON_SKULL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(2314L);
    }

    @Override
    public void addStats(int level, Element v) {
        int chance = ((Config)this.getConfig()).getBaseCooldown() - ((Config)this.getConfig()).getLevelCooldown() * level;
        v.addLore(C.GREEN + String.valueOf(chance) + C.GRAY + " " + Localizer.dLocalize("nether", "skulltoss", "lore1"));
        v.addLore(C.GRAY + Localizer.dLocalize("nether", "skulltoss", "lore2") + C.DARK_GRAY + Localizer.dLocalize("nether", "skulltoss", "lore3") + C.GRAY + ", " + Localizer.dLocalize("nether", "skulltoss", "lore4"));
    }

    private int getCooldownDuration(Player p) {
        return (((Config)this.getConfig()).getBaseCooldown() - ((Config)this.getConfig()).getLevelCooldown() * this.getLevel(p)) * 20;
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.lastJump.remove(p);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (!this.hasAdaptation(e.getPlayer())) {
            return;
        }
        if (e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (e.getAction() != Action.LEFT_CLICK_AIR && e.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND || e.getItem() == null || e.getMaterial() != Material.WITHER_SKELETON_SKULL) {
            return;
        }
        Player p = e.getPlayer();
        if (this.lastJump.get(p) != null && M.ms() - this.lastJump.get(p) <= (long)this.getCooldownDuration(p)) {
            p.playSound((Entity)p, Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.0f);
            return;
        }
        if (this.lastJump.get(p) != null && M.ms() - this.lastJump.get(p) <= (long)this.getCooldownDuration(p)) {
            return;
        }
        if (p.hasCooldown(p.getInventory().getItemInMainHand().getType())) {
            e.setCancelled(true);
            p.playSound((Entity)p, Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.0f);
            return;
        }
        NMS.get().sendCooldown(p, Material.WITHER_SKELETON_SKULL, this.getCooldownDuration(p));
        p.setCooldown(Material.WITHER_SKELETON_SKULL, this.getCooldownDuration(p));
        if (p.getGameMode() != GameMode.CREATIVE) {
            e.getItem().setAmount(e.getItem().getAmount() - 1);
            this.lastJump.put(p, M.ms());
        }
        Vector dir = p.getEyeLocation().getDirection();
        Location spawn = p.getEyeLocation().add(new Vector(0.5, -0.5, 0.5)).add(dir);
        p.getWorld().spawn(spawn, WitherSkull.class, entity -> {
            p.playSound((Entity)entity, Sound.ENTITY_WITHER_SHOOT, 1.0f, 1.0f);
            entity.setRotation(p.getEyeLocation().getYaw(), p.getEyeLocation().getPitch());
            entity.setCharged(false);
            entity.setBounce(false);
            entity.setDirection(dir);
            entity.setShooter((ProjectileSource)p);
            this.xp(p, 100.0);
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        public boolean permanent = false;
        private boolean enabled = true;
        private int baseCooldown = 15;
        private int levelCooldown = 5;
        private int baseCost = 10;
        private double costFactor = 1.5;
        private int maxLevel = 3;
        private int initialCost = 5;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCooldown() {
            return this.baseCooldown;
        }

        public int getLevelCooldown() {
            return this.levelCooldown;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public void setPermanent(boolean permanent) {
            this.permanent = permanent;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setBaseCooldown(int baseCooldown) {
            this.baseCooldown = baseCooldown;
        }

        public void setLevelCooldown(int levelCooldown) {
            this.levelCooldown = levelCooldown;
        }

        public void setBaseCost(int baseCost) {
            this.baseCost = baseCost;
        }

        public void setCostFactor(double costFactor) {
            this.costFactor = costFactor;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public void setInitialCost(int initialCost) {
            this.initialCost = initialCost;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != other.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getBaseCooldown() != other.getBaseCooldown()) {
                return false;
            }
            if (this.getLevelCooldown() != other.getLevelCooldown()) {
                return false;
            }
            if (this.getBaseCost() != other.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), other.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != other.getMaxLevel()) {
                return false;
            }
            return this.getInitialCost() == other.getInitialCost();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPermanent() ? 79 : 97);
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getBaseCooldown();
            result = result * 59 + this.getLevelCooldown();
            result = result * 59 + this.getBaseCost();
            long $costFactor = Double.doubleToLongBits(this.getCostFactor());
            result = result * 59 + (int)($costFactor >>> 32 ^ $costFactor);
            result = result * 59 + this.getMaxLevel();
            result = result * 59 + this.getInitialCost();
            return result;
        }

        public String toString() {
            return "NetherSkullYeet.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCooldown=" + this.getBaseCooldown() + ", levelCooldown=" + this.getLevelCooldown() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

