/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class NetherWitherResist
extends SimpleAdaptation<Config> {
    private static final Random RANDOM;

    public NetherWitherResist() {
        super("nether-wither-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "witherresist", "description"));
        this.setDisplayName(Localizer.dLocalize("nether", "witherresist", "name"));
        this.setIcon(Material.NETHERITE_CHESTPLATE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9283L);
    }

    @Override
    public void addStats(int level, Element v) {
        int chance = (int)(((Config)this.getConfig()).basePieceChance + ((Config)this.getConfig()).getChanceAddition() * (double)level);
        v.addLore(C.GREEN + "+ " + chance + "%" + C.GRAY + Localizer.dLocalize("nether", "witherresist", "lore1"));
        v.addLore(C.GRAY + " " + Localizer.dLocalize("nether", "witherresist", "lore1") + C.DARK_GRAY + Localizer.dLocalize("nether", "witherresist", "lore2"));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        Entity entity;
        if (e.isCancelled()) {
            return;
        }
        if (e.getCause() == EntityDamageEvent.DamageCause.WITHER && (entity = e.getEntity()) instanceof Player) {
            Player p = (Player)entity;
            if (!this.hasAdaptation(p)) {
                return;
            }
            double chance = this.getTotalChange(p);
            if ((double)RANDOM.nextInt(0, 101) <= chance) {
                e.setCancelled(true);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    @Override
    public void onTick() {
    }

    private double getTotalChange(Player p) {
        return this.getChance(p, EquipmentSlot.HEAD) + this.getChance(p, EquipmentSlot.CHEST) + this.getChance(p, EquipmentSlot.LEGS) + this.getChance(p, EquipmentSlot.FEET);
    }

    private double getChance(Player p, EquipmentSlot slot) {
        if (p.getEquipment() == null) {
            return 0.0;
        }
        ItemStack item = p.getEquipment().getItem(slot);
        if (item.getType() == Material.NETHERITE_HELMET || item.getType() == Material.NETHERITE_CHESTPLATE || item.getType() == Material.NETHERITE_LEGGINGS || item.getType() == Material.NETHERITE_BOOTS) {
            return ((Config)this.getConfig()).basePieceChance + ((Config)this.getConfig()).chanceAddition * (double)this.getLevel(p);
        }
        return 0.0;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        RANDOM = new Random();
    }

    public static class Config {
        public boolean permanent = false;
        private boolean enabled = true;
        private int baseCost = 3;
        private double costFactor = 1.0;
        private int maxLevel = 3;
        private int initialCost = 5;
        private double basePieceChance = 10.0;
        private double chanceAddition = 5.0;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public double getBasePieceChance() {
            return this.basePieceChance;
        }

        public double getChanceAddition() {
            return this.chanceAddition;
        }

        public void setPermanent(boolean permanent) {
            this.permanent = permanent;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setBaseCost(int baseCost) {
            this.baseCost = baseCost;
        }

        public void setCostFactor(double costFactor) {
            this.costFactor = costFactor;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public void setInitialCost(int initialCost) {
            this.initialCost = initialCost;
        }

        public void setBasePieceChance(double basePieceChance) {
            this.basePieceChance = basePieceChance;
        }

        public void setChanceAddition(double chanceAddition) {
            this.chanceAddition = chanceAddition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != other.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getBaseCost() != other.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), other.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != other.getMaxLevel()) {
                return false;
            }
            if (this.getInitialCost() != other.getInitialCost()) {
                return false;
            }
            if (Double.compare(this.getBasePieceChance(), other.getBasePieceChance()) != 0) {
                return false;
            }
            return Double.compare(this.getChanceAddition(), other.getChanceAddition()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPermanent() ? 79 : 97);
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getBaseCost();
            long $costFactor = Double.doubleToLongBits(this.getCostFactor());
            result = result * 59 + (int)($costFactor >>> 32 ^ $costFactor);
            result = result * 59 + this.getMaxLevel();
            result = result * 59 + this.getInitialCost();
            long $basePieceChance = Double.doubleToLongBits(this.getBasePieceChance());
            result = result * 59 + (int)($basePieceChance >>> 32 ^ $basePieceChance);
            long $chanceAddition = Double.doubleToLongBits(this.getChanceAddition());
            result = result * 59 + (int)($chanceAddition >>> 32 ^ $chanceAddition);
            return result;
        }

        public String toString() {
            return "NetherWitherResist.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", basePieceChance=" + this.getBasePieceChance() + ", chanceAddition=" + this.getChanceAddition() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

