/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeChisel
extends SimpleAdaptation<Config> {
    public PickaxeChisel() {
        super("pickaxe-chisel");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "chisel", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "chisel", "name"));
        this.setIcon(Material.IRON_NUGGET);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(7433L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getDropChance(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "chisel", "lore1"));
        v.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(level)) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "chisel", "lore2"));
    }

    private int getCooldownTime(double levelPercent) {
        return ((Config)this.getConfig()).cooldownTime;
    }

    private double getDropChance(double levelPercent) {
        return levelPercent * ((Config)this.getConfig()).dropChanceFactor + ((Config)this.getConfig()).dropChanceBase;
    }

    private double getBreakChance(double levelPercent) {
        return ((Config)this.getConfig()).breakChance;
    }

    private int getDamagePerBlock(double levelPercent) {
        return (int)(((Config)this.getConfig()).damagePerBlockBase + ((Config)this.getConfig()).damageFactorInverseMultiplier * (1.0 - levelPercent));
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (e.getClickedBlock() != null && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && this.isPickaxe(p.getInventory().getItemInMainHand()) && this.hasAdaptation(p)) {
            if (p.getInventory().getItemInMainHand().getEnchantments().containsKey(Enchantment.SILK_TOUCH) || p.getInventory().getItemInMainHand().getEnchantments().containsKey(Enchantment.MENDING)) {
                return;
            }
            if (p.getCooldown(p.getInventory().getItemInMainHand().getType()) > 0) {
                return;
            }
            BlockData b = e.getClickedBlock().getBlockData();
            if (this.isOre(b)) {
                p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 1.4f);
                p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_METAL_HIT, 1.25f, 1.7f);
                this.getSkill().xp(p, 37.0);
                p.setCooldown(p.getInventory().getItemInMainHand().getType(), this.getCooldownTime(this.getLevelPercent(p)));
                this.damageHand(p, this.getDamagePerBlock(this.getLevelPercent(p)));
                Location c = p.rayTraceBlocks(8.0).getHitPosition().toLocation(p.getWorld());
                ItemStack is = this.getDropFor(b);
                if (M.r(this.getDropChance(this.getLevelPercent(p)))) {
                    this.xp(p, 5.0);
                    if (((Config)this.getConfig()).showParticles) {
                        e.getClickedBlock().getWorld().spawnParticle(Particle.ITEM_CRACK, c, 14, 0.1, 0.01, 0.01, 0.1, (Object)is);
                    }
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 0.787f);
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_PLACE, 0.55f, 1.89f);
                    e.getClickedBlock().getWorld().dropItemNaturally(c.clone().subtract(p.getLocation().getDirection().clone().multiply(0.1)), is);
                } else if (((Config)this.getConfig()).showParticles) {
                    e.getClickedBlock().getWorld().spawnParticle(Particle.ITEM_CRACK, c, 3, 0.01, 0.01, 0.01, 0.1, (Object)is);
                    e.getClickedBlock().getWorld().spawnParticle(Particle.BLOCK_CRACK, c, 9, 0.1, 0.1, 0.1, (Object)e.getClickedBlock().getBlockData());
                }
                if (M.r(this.getBreakChance(this.getLevelPercent(p)))) {
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_BASALT_BREAK, 1.25f, 0.4f);
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.25f, 0.887f);
                    e.getClickedBlock().breakNaturally(p.getInventory().getItemInMainHand());
                }
            }
        }
    }

    private ItemStack getDropFor(BlockData b) {
        return switch (b.getMaterial()) {
            case Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE -> new ItemStack(Material.COAL);
            case Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE -> new ItemStack(Material.RAW_COPPER);
            case Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.NETHER_GOLD_ORE -> new ItemStack(Material.RAW_GOLD);
            case Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE -> new ItemStack(Material.RAW_IRON);
            case Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE -> new ItemStack(Material.DIAMOND);
            case Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE -> new ItemStack(Material.LAPIS_LAZULI);
            case Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE -> new ItemStack(Material.EMERALD);
            case Material.NETHER_QUARTZ_ORE -> new ItemStack(Material.QUARTZ);
            case Material.REDSTONE_ORE -> new ItemStack(Material.REDSTONE);
            default -> new ItemStack(Material.AIR);
        };
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 7;
        int initialCost = 5;
        double costFactor = 0.4;
        int cooldownTime = 5;
        double dropChanceBase = 0.07;
        double dropChanceFactor = 0.22;
        double breakChance = 0.25;
        double damagePerBlockBase = 1.0;
        double damageFactorInverseMultiplier = 2.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

