/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import xyz.xenondevs.particle.utils.MathUtils;

public class RangedArrowRecovery
extends SimpleAdaptation<Config> {
    private final Map<Arrow, Player> shotArrows;

    public RangedArrowRecovery() {
        super("ranged-recovery");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "arrowrecovery", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "arrowrecovery", "name"));
        this.setIcon(Material.ARROW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.shotArrows = new HashMap<Arrow, Player>();
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        Entity entity;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && this.hasAdaptation(player = (Player)livingEntity) && !event.getBow().containsEnchantment(Enchantment.ARROW_INFINITE) && (entity = event.getProjectile()) instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            this.shotArrows.put(arrow, player);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (projectile instanceof Arrow) {
            Arrow arrow = (Arrow)projectile;
            Player shooter = this.shotArrows.get(arrow);
            if (shooter != null && this.hasAdaptation(shooter)) {
                int level = this.getLevel(shooter);
                double chance = ((Config)this.getConfig()).hitChance[level - 1] / 100.0;
                if (MathUtils.RANDOM.nextDouble() < chance) {
                    ItemStack arrowStack = new ItemStack(Material.ARROW, 1);
                    shooter.getInventory().addItem(new ItemStack[]{arrowStack});
                    Adapt.info("Arrow added to inventory.");
                }
            }
            this.shotArrows.remove(arrow);
        }
    }

    private double chancePerLevel(int level) {
        return ((Config)this.getConfig()).hitChance[level - 1] / 100.0;
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("ranged", "arrowrecovery", "lore1"));
        v.addLore(C.GREEN + Localizer.dLocalize("ranged", "arrowrecovery", "lore2") + this.chancePerLevel(level));
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 8;
        int initialCost = 5;
        double costFactor = 1.1;
        double[] hitChance = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0};

        static {
            IBootstrap.dasBoot();
        }
    }
}

