/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class RangedForce
extends SimpleAdaptation<Config> {
    public RangedForce() {
        super("ranged-force");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "forceshot", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "forceshot", "name"));
        this.setIcon(Material.ARROW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4900L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.SPECTRAL_ARROW).key("challenge_force_30").title(Localizer.dLocalize("ranged", "forceshot", "advancementname")).description(Localizer.dLocalize("ranged", "forceshot", "advancementlore")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build());
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("ranged", "forceshot", "lore1"));
    }

    private double getSpeed(double factor) {
        return factor * ((Config)this.getConfig()).speedFactor;
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Projectile r;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Projectile && (entity = (r = (Projectile)entity).getShooter()) instanceof Player && this.hasAdaptation(p = (Player)entity) && !this.getPlayer(p).getData().isGranted("challenge_force_30")) {
            Location a = e.getEntity().getLocation().clone();
            Location b = p.getLocation().clone();
            a.setY(0.0);
            b.setY(0.0);
            this.xp(p, 5.0);
            if (a.distanceSquared(b) > 10.0 && AdaptConfig.get().isAdvancements()) {
                this.getPlayer(p).getAdvancementHandler().grant("challenge_force_30");
                this.getSkill().xp(p, ((Config)this.getConfig()).challengeRewardLongShotReward);
            }
        }
    }

    @EventHandler
    public void on(ProjectileLaunchEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player && this.hasAdaptation(p = (Player)projectileSource)) {
            double factor = this.getLevelPercent(p);
            e.getEntity().setVelocity(e.getEntity().getVelocity().clone().multiply(1.0 + this.getSpeed(factor)));
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_SNOWBALL_THROW, 0.5f + (float)factor * 0.25f, 0.7f + (float)(factor / 2.0));
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int maxLevel = 7;
        int initialCost = 5;
        double costFactor = 0.225;
        double challengeRewardLongShotReward = 2000.0;
        double speedFactor = 1.135;

        static {
            IBootstrap.dasBoot();
        }
    }
}

