/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class RangedLungeShot
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public RangedLungeShot() {
        super("ranged-lunge-shot");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "lungeshot", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "lungeshot", "name"));
        this.setIcon(Material.FEATHER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4859L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    private double getSpeed(double factor) {
        return factor * ((Config)this.getConfig()).factor;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("ranged", "lungeshot", "lore1"));
    }

    @EventHandler
    public void on(ProjectileLaunchEvent e) {
        if (e.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player p = (Player)projectileSource;
            Projectile projectile = e.getEntity();
            if (projectile instanceof AbstractArrow) {
                AbstractArrow a = (AbstractArrow)projectile;
                if (this.hasAdaptation(p) && !p.isOnGround()) {
                    Vector velocity = p.getPlayer().getLocation().getDirection().normalize().multiply(this.getSpeed(this.getLevelPercent(p)));
                    p.setVelocity(p.getVelocity().subtract(velocity));
                    p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_TURTLE, 1.0f, 0.75f);
                    p.getWorld().playSound(p.getLocation(), Sound.ITEM_CROSSBOW_SHOOT, 1.0f, 1.95f);
                    for (int i = 0; i < 9; ++i) {
                        Vector v = velocity.clone().add(Vector.getRandom().subtract(Vector.getRandom()).multiply(0.3)).normalize();
                        if (!((Config)this.getConfig()).showParticles) continue;
                        p.getWorld().spawnParticle(Particle.CLOUD, p.getLocation().clone().add(0.0, 1.0, 0.0), 0, v.getX(), v.getY(), v.getZ(), 0.2);
                    }
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        int maxLevel = 3;
        int initialCost = 8;
        double costFactor = 0.5;
        double factor = 0.935;

        static {
            IBootstrap.dasBoot();
        }
    }
}

