/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.recipe.MaterialChar;
import com.volmit.adapt.content.item.BoundSnowBall;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class RangedWebBomb
extends SimpleAdaptation<Config> {
    private static final BlockData AIR;
    private static final BlockData BLOCK;
    private final Map<Entity, Player> activeSnowballs;
    private final Set<Block> activeBlocks;

    public RangedWebBomb() {
        super("ranged-webshot");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "webshot", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "webshot", "name"));
        this.setIcon(Material.COBWEB);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4900L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.registerRecipe(AdaptRecipe.shaped().key("ranged-web-bomb").ingredient(new MaterialChar('I', Material.COBWEB)).ingredient(new MaterialChar('S', Material.SNOWBALL)).shapes(List.of("III", "ISI", "III")).result(BoundSnowBall.io.withData(new BoundSnowBall.Data(null))).build());
        this.activeBlocks = new HashSet<Block>();
        this.activeSnowballs = new HashMap<Entity, Player>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Localizer.dLocalize("ranged", "webshot", "lore1"));
        v.addLore(C.YELLOW + "+ " + level + C.GRAY + " " + Localizer.dLocalize("ranged", "webshot", "lore2"));
    }

    @EventHandler
    public void on(ProjectileHitEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Block block = e.getHitEntity() != null ? e.getHitEntity().getLocation().add(0.0, 1.0, 0.0).getBlock() : (e.getHitBlock() != null ? e.getHitBlock().getLocation().add(0.0, 1.0, 0.0).getBlock() : e.getEntity().getLocation().add(0.0, 1.0, 0.0).getBlock());
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player p = (Player)projectileSource;
            projectileSource = e.getEntity();
            if (projectileSource instanceof Snowball) {
                Snowball snowball = (Snowball)projectileSource;
                if (this.hasAdaptation(p)) {
                    this.vfxCuboidOutline(block, Particle.REVERSE_PORTAL);
                    Adapt.verbose("Snowball Got: " + snowball.getEntityId() + " " + snowball.getUniqueId());
                    if (this.activeSnowballs.containsKey(Bukkit.getEntity((UUID)snowball.getUniqueId()))) {
                        Adapt.verbose("Detected snowball hit");
                        this.activeSnowballs.remove(snowball);
                        snowball.remove();
                        HashSet<Block> locs = new HashSet<Block>();
                        locs.add(block.getLocation().add(0.0, 1.0, 0.0).getBlock());
                        locs.add(block.getLocation().add(0.0, -1.0, 0.0).getBlock());
                        locs.add(block.getLocation().add(0.0, 0.0, 1.0).getBlock());
                        locs.add(block.getLocation().add(0.0, 0.0, -1.0).getBlock());
                        locs.add(block.getLocation().add(1.0, 0.0, 0.0).getBlock());
                        locs.add(block.getLocation().add(-1.0, 0.0, 0.0).getBlock());
                        for (Block i : locs) {
                            this.addWebFoundation(i, this.getLevel(p));
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void on(ProjectileLaunchEvent e) {
        if (e.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player p = (Player)projectileSource;
            projectileSource = e.getEntity();
            if (projectileSource instanceof Snowball) {
                Snowball snowball = (Snowball)projectileSource;
                if (this.hasAdaptation(p)) {
                    Adapt.verbose("Snowball Launched: " + snowball.getEntityId() + " " + snowball.getUniqueId());
                    if (BoundSnowBall.isBindableItem(snowball.getItem())) {
                        Adapt.verbose("Snowball is bound");
                        this.activeSnowballs.put((Entity)snowball, p);
                    } else {
                        Adapt.verbose("Snowball is not bound");
                    }
                }
            }
        }
    }

    public void addWebFoundation(Block block, int seconds) {
        if (!block.getType().isAir()) {
            return;
        }
        J.s(() -> {
            block.setBlockData(BLOCK);
            this.activeBlocks.add(block);
        });
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_ROOTED_DIRT_PLACE, 1.0f, 1.0f);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.CLOUD);
            this.vfxCuboidOutline(block, Particle.WHITE_ASH);
        }
        J.a(() -> this.removeFoundation(block), seconds * 16);
    }

    public void removeFoundation(Block block) {
        if (!block.getBlockData().equals(BLOCK)) {
            return;
        }
        J.s(() -> {
            block.setBlockData(AIR);
            this.activeBlocks.remove(block);
        });
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_ROOTED_DIRT_BREAK, 1.0f, 1.0f);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.ENCHANTMENT_TABLE);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPistonExtendEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.getBlocks().forEach(b -> {
            if (this.activeBlocks.contains(b)) {
                Adapt.verbose("Cancelled Piston Extend on Adaptation Foundation Block");
                e.setCancelled(true);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPistonRetractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.getBlocks().forEach(b -> {
            if (this.activeBlocks.contains(b)) {
                Adapt.verbose("Cancelled Piston Retract on Adaptation Foundation Block");
                e.setCancelled(true);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockExplodeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (this.activeBlocks.contains(e.getBlock())) {
            Adapt.verbose("Cancelled Block Explosion on Adaptation Foundation Block");
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent e) {
        if (this.activeBlocks.contains(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityExplodeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.blockList().removeIf(this.activeBlocks::contains);
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        AIR = Material.AIR.createBlockData();
        BLOCK = Material.COBWEB.createBlockData();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 1;
        double costFactor = 1.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

