/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.item.BoundEnderPearl;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import us.lynuxcraft.deadsilenceiv.advancedchests.AdvancedChestsAPI;

public class RiftAccess
extends SimpleAdaptation<Config> {
    private final List<InventoryView> activeViews = new ArrayList<InventoryView>();

    public RiftAccess() {
        super("rift-access");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "remoteaccess", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "remoteaccess", "name"));
        this.setMaxLevel(1);
        this.setIcon(Material.NETHER_STAR);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(5544L);
        this.registerRecipe(AdaptRecipe.shapeless().key("rift-remote-access").ingredient(Material.ENDER_PEARL).ingredient(Material.COMPASS).result(BoundEnderPearl.io.withData(new BoundEnderPearl.Data(null))).build());
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore1"));
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore2"));
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "remoteaccess", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack mainHand = p.getInventory().getItemInMainHand();
        ItemStack offHand = p.getInventory().getItemInOffHand();
        Block block = e.getClickedBlock();
        boolean mainHandBound = BoundEnderPearl.isBindableItem(mainHand);
        boolean offHandBound = BoundEnderPearl.isBindableItem(offHand);
        if (offHandBound && e.getHand() != null && e.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            e.setCancelled(true);
            return;
        }
        if (mainHandBound) {
            e.setCancelled(true);
            if (this.hasAdaptation(p)) {
                Adapt.verbose("Player using bound enderpearl.");
                this.handleEnderPearlInteraction(e, p, block);
            }
        }
    }

    private void handleEnderPearlInteraction(PlayerInteractEvent event, Player player, Block block) {
        boolean allowed;
        boolean canUseInCreative = AdaptConfig.get().allowAdaptationsInCreative;
        boolean isCreative = player.getGameMode() == GameMode.CREATIVE;
        boolean sneaking = player.isSneaking();
        boolean bl = allowed = canUseInCreative || !isCreative;
        if (!allowed) {
            Adapt.info("Player " + player.getName() + " tried to use the bound item in creative mode.");
            return;
        }
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: {
                if (!sneaking || !this.isStorage(block.getBlockData())) break;
                if (this.canAccessChest(player, block.getLocation())) {
                    this.linkPearl(player, block, event);
                    break;
                }
                Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                this.openPearl(player);
                break;
            }
        }
    }

    private void linkPearl(Player p, Block block, PlayerInteractEvent event) {
        event.setCancelled(true);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.REVERSE_PORTAL);
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_CLOSE, 0.5f, 0.8f);
        if (hand.getAmount() == 1) {
            BoundEnderPearl.setData(hand, block);
        } else {
            hand.setAmount(hand.getAmount() - 1);
            ItemStack pearl = BoundEnderPearl.withData(block);
            p.getInventory().addItem(new ItemStack[]{pearl}).values().forEach(i -> p.getWorld().dropItemNaturally(p.getLocation(), i));
        }
    }

    private void openPearl(Player p) {
        Block b = BoundEnderPearl.getBlock(p.getInventory().getItemInMainHand());
        if (b == null || !this.canAccessChest(p, b.getLocation())) {
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            return;
        }
        ChunkLoading.loadChunkAsync(b.getLocation(), chunk -> {
            if (Bukkit.getPluginManager().isPluginEnabled("AdvancedChests") && AdvancedChestsAPI.getChestManager().getAdvancedChest(b.getLocation()) != null) {
                AdvancedChestsAPI.getChestManager().getAdvancedChest(b.getLocation()).openPage((HumanEntity)p, 1);
                Adapt.verbose("Opening AdvancedChests GUI");
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
            } else {
                BlockState patt7246$temp = b.getState();
                if (patt7246$temp instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)patt7246$temp;
                    this.activeViews.add(p.openInventory(holder.getInventory()));
                    p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                    p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                }
            }
        });
    }

    private boolean isBound(ItemStack stack) {
        return stack.getType().equals((Object)Material.ENDER_PEARL) && BoundEnderPearl.getBlock(stack) != null;
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        J.s(() -> {
            for (int ii = this.activeViews.size() - 1; ii >= 0; --ii) {
                InventoryView i = this.activeViews.get(ii);
                if (i.getPlayer().getOpenInventory().equals(i)) {
                    if (i.getTopInventory().getLocation() != null && this.isStorage(i.getTopInventory().getLocation().getBlock().getBlockData())) continue;
                    i.getPlayer().closeInventory();
                    i.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
                    this.activeViews.remove(ii);
                    continue;
                }
                i.getPlayer().removePotionEffect(PotionEffectType.BLINDNESS);
                this.activeViews.remove(ii);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        double costFactor = 0.2;
        int initialCost = 15;

        static {
            IBootstrap.dasBoot();
        }
    }
}

