/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.adaptation.chunk.ChunkLoading;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.util.Vector;

public class RiftBlink
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> lastJump = new HashMap<Player, Long>();
    private final Map<Player, Boolean> canBlink = new HashMap<Player, Boolean>();
    private final double jumpVelocity = -0.0784000015258789;

    public RiftBlink() {
        super("rift-blink");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "blink", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "blink", "name"));
        this.setIcon(Material.FEATHER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9288L);
    }

    private double getBlinkDistance(int level) {
        return ((Config)this.getConfig()).baseDistance + this.getLevelPercent(level) * ((Config)this.getConfig()).distanceFactor;
    }

    private int getCooldownDuration() {
        return 2000;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + this.getBlinkDistance(level) + C.GRAY + " " + Localizer.dLocalize("rift", "blink", "lore1"));
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "blink", "lore2") + C.DARK_PURPLE + Localizer.dLocalize("rift", "blink", "lore3"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.lastJump.remove(p);
        this.canBlink.remove(p);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerToggleFlightEvent e) {
        Player p = e.getPlayer();
        if (this.hasAdaptation(p) && p.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            e.setCancelled(true);
            p.setAllowFlight(false);
            if (this.lastJump.get(p) != null && M.ms() - this.lastJump.get(p) <= (long)this.getCooldownDuration()) {
                return;
            }
            if (p.isSprinting()) {
                Location loc = p.getLocation().clone();
                Location locOG = p.getLocation().clone();
                Vector dir = loc.getDirection();
                double dist = this.getBlinkDistance(this.getLevel(p));
                dir.multiply(dist);
                loc.add(dir);
                double cd = dist * 2.0;
                loc.subtract(0.0, dist, 0.0);
                while (!this.isSafe(loc)) {
                    double d = cd;
                    cd = d - 1.0;
                    if (!(d > 0.0)) break;
                    loc.add(0.0, 1.0, 0.0);
                }
                if (!this.isSafe(loc)) {
                    p.getWorld().playSound(p.getLocation(), Sound.BLOCK_CONDUIT_DEACTIVATE, 1.0f, 1.24f);
                    this.lastJump.put(p, M.ms());
                    return;
                }
                if (this.getPlayer(p).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist") != null && this.getPlayer(p).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist").getLevel() > 0) {
                    RiftResist.riftResistStackAdd(p, 10, 5);
                }
                if (((Config)this.getConfig()).showParticles) {
                    this.vfxParticleLine(locOG, loc, Particle.REVERSE_PORTAL, 50, 8, 0.1, 1.0, 0.1, 0.0, null, false, l -> l.getBlock().isPassable());
                }
                Vector v = p.getVelocity().clone();
                ChunkLoading.loadChunkAsync(loc, chunk -> {
                    J.s(() -> p.teleport(loc.add(0.0, 1.0, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN));
                    J.s(() -> p.setVelocity(v.multiply(3)), 2);
                });
                this.lastJump.put(p, M.ms());
                p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 1.0f);
                this.vfxLevelUp(p);
            }
        }
    }

    @EventHandler
    public void on(PlayerMoveEvent e) {
        boolean isJumping;
        Player p = e.getPlayer();
        boolean bl = isJumping = p.getVelocity().getY() > -0.0784000015258789;
        if (isJumping && !this.canBlink.containsKey(p) && this.hasAdaptation(p) && p.getGameMode().equals((Object)GameMode.SURVIVAL) && p.isSprinting()) {
            if (this.lastJump.get(p) != null && M.ms() - this.lastJump.get(p) <= (long)this.getCooldownDuration()) {
                p.setAllowFlight(false);
                return;
            }
            Location loc = p.getLocation().clone();
            Vector dir = loc.getDirection();
            double dist = this.getBlinkDistance(this.getLevel(p));
            dir.multiply(dist);
            loc.add(dir);
            double cd = dist * 2.0;
            loc.subtract(0.0, dist, 0.0);
            while (!this.isSafe(loc)) {
                double d = cd;
                cd = d - 1.0;
                if (!(d > 0.0)) break;
                loc.add(0.0, 1.0, 0.0);
            }
            if (this.isSafe(loc)) {
                this.canBlink.put(p, true);
                p.setAllowFlight(true);
                Adapt.verbose("Allowing flight for " + p.getName());
                J.a(() -> {
                    p.setAllowFlight(false);
                    p.setFlying(false);
                    Adapt.verbose("Disabling flight for " + p.getName());
                    this.canBlink.remove(p);
                }, 25);
            }
        } else {
            this.canBlink.remove(p);
        }
    }

    private boolean isSafe(Location l) {
        return l.getBlock().getType().isSolid() && !l.getBlock().getRelative(BlockFace.UP).getType().isSolid() && !l.getBlock().getRelative(BlockFace.UP).getRelative(BlockFace.UP).getType().isSolid();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        double costFactor = 0.12;
        int maxLevel = 5;
        int initialCost = 1;
        double baseDistance = 6.0;
        double distanceFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

