/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.seaborrne;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class SeaborneOxygen
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public SeaborneOxygen() {
        super("seaborne-oxygen");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("seaborn", "oxygen", "description"));
        this.setDisplayName(Localizer.dLocalize("seaborn", "oxygen", "name"));
        this.setIcon(Material.GLASS_PANE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(3750L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getAirBoost(level), 0) + C.GRAY + Localizer.dLocalize("seaborn", "oxygen", "lore1"));
    }

    public int getRealMaxAir(int level) {
        return (int)(this.getAirBoost(level) * 300.0 + 300.0);
    }

    public double getAirBoost(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).airFactor;
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            if (this.getLevel(i) <= 0) continue;
            i.setMaximumAir(this.getRealMaxAir(this.getLevel(i)));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 0.525;
        double airFactor = 4.55;

        static {
            IBootstrap.dasBoot();
        }
    }
}

