/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.sword;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class SwordsMachete
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public SwordsMachete() {
        super("sword-machete");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("sword", "machete", "description"));
        this.setDisplayName(Localizer.dLocalize("sword", "machete", "name"));
        this.setIcon(Material.IRON_SWORD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(5234L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + this.getRadius(level) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore1"));
        v.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(level)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore2"));
        v.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(level)) + C.GRAY + " " + Localizer.dLocalize("sword", "machete", "lore3"));
    }

    public double getRadius(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).radiusFactor + ((Config)this.getConfig()).radiusBase;
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (e.getHand() != null && e.getHand().equals((Object)EquipmentSlot.HAND) && e.getAction().equals((Object)Action.LEFT_CLICK_AIR) || e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            int dmg = 0;
            ItemStack is = e.getItem();
            if (this.isSword(is) && is != null && !p.hasCooldown(is.getType()) && this.hasAdaptation(p)) {
                Location ctr = p.getEyeLocation().clone().add(p.getLocation().getDirection().clone().multiply(2.25)).add(0.0, -0.5, 0.0);
                int lvl = this.getLevel(p);
                Cuboid c = new Cuboid(ctr);
                c = c.expand(Cuboid.CuboidDirection.Up, (int)Math.floor(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.Down, (int)Math.floor(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.North, (int)Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.South, (int)Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.East, (int)Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.West, (int)Math.round(this.getRadius(lvl)));
                if (dmg > 0) {
                    return;
                }
                for (Block i : c) {
                    if (!M.r(this.getLevelPercent(lvl) * 2.8 / i.getLocation().distanceSquared(ctr)) || !i.getType().equals((Object)Material.TALL_GRASS) && !i.getType().equals((Object)Material.CACTUS) && !i.getType().equals((Object)Material.SUGAR_CANE) && !i.getType().equals((Object)Material.CARROT) && !i.getType().equals((Object)Material.POTATO) && !i.getType().equals((Object)Material.NETHER_WART) && !i.getType().equals((Object)Material.GRASS) && !i.getType().equals((Object)Material.FERN) && !i.getType().equals((Object)Material.LARGE_FERN) && !i.getType().equals((Object)Material.VINE) && !i.getType().equals((Object)Material.ROSE_BUSH) && !i.getType().equals((Object)Material.WITHER_ROSE) && !i.getType().equals((Object)Material.ACACIA_LEAVES) && !i.getType().equals((Object)Material.BIRCH_LEAVES) && !i.getType().equals((Object)Material.DARK_OAK_LEAVES) && !i.getType().equals((Object)Material.JUNGLE_LEAVES) && !i.getType().equals((Object)Material.OAK_LEAVES) && !i.getType().equals((Object)Material.SPRUCE_LEAVES) && !i.getType().equals((Object)Material.BROWN_MUSHROOM) && !i.getType().equals((Object)Material.RED_MUSHROOM) && !i.getType().equals((Object)Material.DEAD_BUSH) && !i.getType().equals((Object)Material.DANDELION) && !i.getType().equals((Object)Material.TALL_SEAGRASS) && !i.getType().equals((Object)Material.SEAGRASS) && !i.getType().equals((Object)Material.WHITE_TULIP) && !i.getType().equals((Object)Material.RED_TULIP) && !i.getType().equals((Object)Material.PINK_TULIP) && !i.getType().equals((Object)Material.ORANGE_TULIP) && !i.getType().equals((Object)Material.LILY_OF_THE_VALLEY) && !i.getType().equals((Object)Material.ALLIUM) && !i.getType().equals((Object)Material.AZURE_BLUET) && !i.getType().equals((Object)Material.SUNFLOWER) && !i.getType().equals((Object)Material.CORNFLOWER) && !i.getType().equals((Object)Material.CHORUS_FLOWER) && !i.getType().equals((Object)Material.BAMBOO) && !i.getType().equals((Object)Material.BAMBOO_SAPLING) && !i.getType().equals((Object)Material.LILAC) && !i.getType().equals((Object)Material.PEONY) && !i.getType().equals((Object)Material.LILY_PAD) && !i.getType().equals((Object)Material.COCOA) && !i.getType().equals((Object)Material.MANGROVE_LEAVES) || !this.canBlockBreak(p, i.getLocation())) continue;
                    BlockBreakEvent ee = new BlockBreakEvent(i, p);
                    Bukkit.getPluginManager().callEvent((Event)ee);
                    if (ee.isCancelled()) continue;
                    ++dmg;
                    J.s(() -> {
                        i.breakNaturally();
                        p.getWorld().playSound(i.getLocation(), Sound.BLOCK_GRASS_BREAK, 0.4f, (float)Math.random() * 1.85f);
                    }, RNG.r.i(0, this.getMaxLevel() - lvl * 2 + 1));
                }
                if (dmg > 0) {
                    p.setCooldown(is.getType(), this.getCooldownTime(this.getLevelPercent(lvl)));
                    p.getWorld().playSound(p.getEyeLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, (float)(Math.random() / 2.0) + 0.65f);
                    this.damageHand(p, dmg * this.getDamagePerBlock(this.getLevelPercent(lvl)));
                    this.getSkill().xp(p, (double)dmg * 11.25);
                }
            }
        }
    }

    private int getCooldownTime(double levelPercent) {
        return (int)((double)((int)((1.0 - levelPercent) * ((Config)this.getConfig()).cooldownTicksSlowest)) + ((Config)this.getConfig()).cooldownTicksBase);
    }

    private int getDamagePerBlock(double levelPercent) {
        return (int)(((Config)this.getConfig()).toolDamageBase + ((Config)this.getConfig()).toolDamageInverseLevelFactor * (1.0 - levelPercent));
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 4;
        int maxLevel = 3;
        int initialCost = 7;
        double costFactor = 0.225;
        double radiusBase = 0.6;
        double radiusFactor = 2.36;
        double cooldownTicksBase = 7.0;
        double cooldownTicksSlowest = 35.0;
        double toolDamageBase = 1.0;
        double toolDamageInverseLevelFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

