/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.taming;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffectType;

public class TamingHealthRegeneration
extends SimpleAdaptation<Config> {
    private final Map<UUID, Long> lastDamage = new HashMap<UUID, Long>();

    public TamingHealthRegeneration() {
        super("tame-health-regeneration");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("taming", "regeneration", "description"));
        this.setDisplayName(Localizer.dLocalize("taming", "regeneration", "name"));
        this.setIcon(Material.GOLDEN_APPLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(1033L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.f(this.getRegenSpeed(level), 0) + C.GRAY + " " + Localizer.dLocalize("taming", "regeneration", "lore1"));
    }

    @EventHandler
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Tameable tam;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Tameable && (entity = (tam = (Tameable)entity).getOwner()) instanceof Player && this.hasAdaptation(p = (Player)entity)) {
            if (this.lastDamage.containsKey(tam.getUniqueId())) {
                Adapt.verbose("Tamed Entity " + tam.getUniqueId() + " last damaged " + (M.ms() - this.lastDamage.get(tam.getUniqueId())) + "ms ago");
                return;
            }
            double mh = tam.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            if (tam.isTamed() && tam.getOwner() instanceof Player && tam.getHealth() < mh) {
                Adapt.verbose("Successfully healed tamed entity " + tam.getUniqueId());
                int level = this.getLevel(p);
                if (level > 0) {
                    Adapt.verbose("[PRE] Current Health: " + tam.getHealth() + " Max Health: " + mh);
                    tam.addPotionEffect(PotionEffectType.REGENERATION.createEffect(25 * this.getLevel(p), 3));
                    J.a(() -> {
                        try {
                            Thread.sleep((long)this.getLevel(p) * 2000L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        Adapt.verbose("[POST] Current Health: " + tam.getHealth() + " Max Health: " + mh);
                    });
                    if (((Config)this.getConfig()).showParticles) {
                        Adapt.verbose("Healing tamed entity " + tam.getUniqueId() + " with particles");
                        tam.getWorld().spawnParticle(Particle.HEART, tam.getLocation().add(0.0, 1.0, 0.0), 2 * p.getLevel());
                    } else {
                        Adapt.verbose("Healing tamed entity " + tam.getUniqueId() + " without particles");
                    }
                }
            }
            this.lastDamage.put(e.getEntity().getUniqueId(), M.ms());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDeathEvent e) {
        this.lastDamage.remove(e.getEntity().getUniqueId());
    }

    private double getRegenSpeed(int level) {
        return this.getLevelPercent(level) * this.getLevelPercent(level) * ((Config)this.getConfig()).regenFactor + ((Config)this.getConfig()).regenBase;
    }

    @Override
    public void onTick() {
        for (UUID i : XMap.k(this.lastDamage)) {
            if (M.ms() - this.lastDamage.get(i) <= 8000L) continue;
            this.lastDamage.remove(i);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        int maxLevel = 3;
        int initialCost = 8;
        double costFactor = 0.4;
        double regenFactor = 5.0;
        double regenBase = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

