/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.gui;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.UIElement;
import com.volmit.adapt.util.UIWindow;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SkillsGui {
    public static void open(Player player) {
        UIWindow w = new UIWindow(player);
        w.setTag("/");
        w.setDecorator((window, position, row) -> new UIElement("bg").setName(" ").setMaterial(new MaterialBlock(Material.BLACK_STAINED_GLASS_PANE)));
        AdaptPlayer adaptPlayer = Adapt.instance.getAdaptServer().getPlayer(player);
        int ind = 0;
        if (adaptPlayer.getData().getSkillLines().size() > 0) {
            for (PlayerSkillLine i : XMap.sortV(adaptPlayer.getData().getSkillLines())) {
                if (i.getRawSkill(adaptPlayer).hasBlacklistPermission(adaptPlayer.getPlayer(), i.getRawSkill(adaptPlayer)) || i.getLevel() < 0) continue;
                int pos = w.getPosition(ind);
                int row2 = w.getRow(ind);
                int adaptationLevel = 0;
                for (PlayerAdaptation adaptation : XMap.sortV(i.getAdaptations())) {
                    adaptationLevel = adaptation.getLevel();
                }
                Skill<?> sk = Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(i.getLine());
                w.setElement(pos, row2, new UIElement("skill-" + sk.getName()).setMaterial(new MaterialBlock(sk.getIcon())).setName(sk.getDisplayName(i.getLevel())).setProgress(1.0).addLore(C.ITALIC + C.GRAY + sk.getDescription()).addLore(C.UNDERLINE + C.WHITE + i.getKnowledge() + C.RESET + " " + C.GRAY + Localizer.dLocalize("snippets", "gui", "knowledge")).addLore(C.ITALIC + C.GRAY + Localizer.dLocalize("snippets", "gui", "powerused") + " " + C.DARK_GREEN + adaptationLevel).onLeftClick(e -> sk.openGui(player)));
                ++ind;
            }
            if (AdaptConfig.get().isUnlearnAllButton()) {
                int unlearnAllRow;
                int unlearnAllPos = w.getResolution().getWidth() - 1;
                if (w.getElement(unlearnAllPos, unlearnAllRow = w.getViewportHeight() - 1) != null) {
                    ++unlearnAllRow;
                }
                w.setElement(unlearnAllPos, unlearnAllRow, new UIElement("unlearn-all").setMaterial(new MaterialBlock(Material.BARRIER)).setName(C.RESET + C.GRAY + Localizer.dLocalize("snippets", "gui", "unlearnall") + (String)(AdaptConfig.get().isHardcoreNoRefunds() ? " " + C.DARK_RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "norefunds") : "")).onLeftClick(e -> {
                    Adapt.instance.getAdaptServer().getSkillRegistry().getSkills().forEach(skill -> skill.getAdaptations().forEach(adaptation -> adaptation.unlearn(player, 1)));
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_NETHER_GOLD_ORE_PLACE, 0.7f, 1.355f);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.4f, 0.755f);
                    w.close();
                    if (AdaptConfig.get().getLearnUnlearnButtonDelayTicks() != 0) {
                        player.sendTitle(" ", C.GRAY + Localizer.dLocalize("snippets", "gui", "unlearnedall"), 1, 5, 11);
                    }
                    J.s(() -> SkillsGui.open(player), AdaptConfig.get().getLearnUnlearnButtonDelayTicks());
                }));
            }
            w.setTitle(Localizer.dLocalize("snippets", "gui", "level") + " " + (int)XP.getLevelForXp(adaptPlayer.getData().getMasterXp()) + " (" + adaptPlayer.getData().getUsedPower() + "/" + adaptPlayer.getData().getMaxPower() + " " + Localizer.dLocalize("snippets", "gui", "powerused") + ")");
            w.open();
            w.onClosed(e -> Adapt.instance.getGuiLeftovers().remove(player.getUniqueId().toString()));
            Adapt.instance.getGuiLeftovers().put(player.getUniqueId().toString(), w);
        }
    }

    static {
        IBootstrap.dasBoot();
    }
}

