/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExperienceOrb
implements DataItem<Data> {
    public static ExperienceOrb io;

    public static Data get(ItemStack is) {
        return (Data)io.getData(is);
    }

    public static void set(ItemStack item, String skill, double xp) {
        io.setData(item, new Data(skill, xp));
    }

    public static ItemStack with(String skill, double xp) {
        return io.withData(new Data(skill, xp));
    }

    @Override
    public Material getMaterial() {
        return Material.SNOWBALL;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> lore) {
        Skill<?> skill = Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill);
        lore.add(C.WHITE + Localizer.dLocalize("snippets", "experienceorb", "contains") + " " + C.UNDERLINE + C.WHITE + Form.f(data.experience, 0) + " " + skill.getDisplayName() + C.GRAY + " " + Localizer.dLocalize("snippets", "experienceorb", "xp"));
        lore.add(C.LIGHT_PURPLE + Localizer.dLocalize("snippets", "experienceorb", "rightclick") + " " + C.GRAY + Localizer.dLocalize("snippets", "experienceorb", "togainxp"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta meta) {
        meta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        meta.setDisplayName(Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill).getDisplayName() + " " + Localizer.dLocalize("snippets", "experienceorb", "xporb"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperienceOrb)) {
            return false;
        }
        ExperienceOrb other = (ExperienceOrb)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExperienceOrb;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ExperienceOrb()";
    }

    static {
        IBootstrap.dasBoot();
        io = new ExperienceOrb();
    }

    public static class Data {
        private String skill;
        private double experience;

        public void apply(Player p) {
            Adapt.instance.getAdaptServer().getPlayer(p).getSkillLine(this.skill).giveXPFresh(Adapt.instance.getAdaptServer().getPlayer(p).getNot(), this.experience);
        }

        public Data(String skill, double experience) {
            this.skill = skill;
            this.experience = experience;
        }

        public String getSkill() {
            return this.skill;
        }

        public double getExperience() {
            return this.experience;
        }

        public void setSkill(String skill) {
            this.skill = skill;
        }

        public void setExperience(double experience) {
            this.experience = experience;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getExperience(), other.getExperience()) != 0) {
                return false;
            }
            String this$skill = this.getSkill();
            String other$skill = other.getSkill();
            return !(this$skill == null ? other$skill != null : !this$skill.equals(other$skill));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $experience = Double.doubleToLongBits(this.getExperience());
            result = result * 59 + (int)($experience >>> 32 ^ $experience);
            String $skill = this.getSkill();
            result = result * 59 + ($skill == null ? 43 : $skill.hashCode());
            return result;
        }

        public String toString() {
            return "ExperienceOrb.Data(skill=" + this.getSkill() + ", experience=" + this.getExperience() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

