/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item.multiItems;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.BukkitGson;
import com.volmit.adapt.util.WindowResolution;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public interface MultiItem {
    public boolean supportsItem(ItemStack var1);

    public String getKey();

    default public WindowResolution getWindowType() {
        return WindowResolution.W5_H1;
    }

    default public ItemStack build(ItemStack ... stacks) {
        ItemStack s = stacks[0];
        for (int i = 1; i < stacks.length; ++i) {
            this.add(s, stacks[i]);
        }
        return s;
    }

    default public boolean remove(ItemStack multi, ItemStack toRemove) {
        int ind = this.getItems(multi).indexOf(toRemove);
        if (ind == -1) {
            return false;
        }
        this.remove(multi, ind);
        return true;
    }

    default public void remove(ItemStack multi, int index) {
        List<ItemStack> it = this.getItems(multi);
        it.remove(index);
        this.setItems(multi, it);
    }

    default public void add(ItemStack multi, ItemStack item) {
        if (this.isMultiItem(item)) {
            this.explode(item).forEach(i -> this.add(multi, (ItemStack)i));
        } else {
            this.setItems(multi, XList.qadd(this.getItems(multi), item));
        }
    }

    default public ItemStack nextMatching(ItemStack item, Predicate<ItemStack> predicate) {
        List<ItemStack> items = this.getItems(item);
        for (int i = 0; i < items.size(); ++i) {
            if (!predicate.test(items.get(i))) continue;
            return this.switchTo(item, i);
        }
        return item;
    }

    default public ItemStack nextTool(ItemStack multi) {
        return this.switchTo(multi, 0);
    }

    default public ItemStack switchTo(ItemStack multi, int index) {
        List<ItemStack> items = this.getItems(multi);
        ItemStack next = items.remove(index);
        items.add(this.getRealItem(multi));
        this.setItems(next, items);
        return next;
    }

    default public void setItems(ItemStack multi, List<ItemStack> itemStacks) {
        this.setMultiItemData(multi, MultiItemData.builder().rawItems(itemStacks.stream().filter(this::supportsItem).map(i -> NMS.get().serializeStack((ItemStack)i)).collect(Collectors.toList())).build());
    }

    default public List<ItemStack> getItems(ItemStack multi) {
        MultiItemData d = this.getMultiItemData(multi);
        if (d == null) {
            return new ArrayList<ItemStack>();
        }
        return d.getItems();
    }

    default public List<ItemStack> explode(ItemStack multi) {
        ArrayList<ItemStack> it = new ArrayList<ItemStack>();
        it.add(this.getRealItem(multi));
        XList.add(it, this.getItems(multi));
        return it;
    }

    public void onApplyMeta(ItemStack var1, ItemMeta var2, List<ItemStack> var3);

    default public boolean isMultiItem(ItemStack item) {
        return this.supportsItem(item) && this.getMultiItemData(item) != null;
    }

    default public ItemStack getRealItem(ItemStack multi) {
        ItemStack c = multi.clone();
        if (c.hasItemMeta()) {
            ItemMeta meta = c.getItemMeta();
            meta.getPersistentDataContainer().remove(new NamespacedKey((Plugin)Adapt.instance, this.getKey()));
            c.setItemMeta(meta);
        }
        return c;
    }

    default public MultiItemData getMultiItemData(ItemStack multi) {
        try {
            ItemMeta meta = multi.getItemMeta();
            String st = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), PersistentDataType.STRING);
            return (MultiItemData)BukkitGson.gson.fromJson(st, MultiItemData.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    default public void setMultiItemData(ItemStack multi, MultiItemData data) {
        String s = BukkitGson.gson.toJson((Object)data);
        ItemMeta meta = multi.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)Adapt.instance, this.getKey()), PersistentDataType.STRING, (Object)s);
        multi.setItemMeta(meta);
        meta = multi.getItemMeta();
        this.onApplyMeta(multi, meta, this.getItems(multi));
        multi.setItemMeta(meta);
    }

    public static class MultiItemData {
        List<String> rawItems;

        List<ItemStack> getItems() {
            return this.rawItems.stream().map(i -> NMS.get().deserializeStack((String)i)).collect(Collectors.toList());
        }

        void setItems(List<ItemStack> is) {
            this.rawItems = is.stream().map(i -> NMS.get().serializeStack((ItemStack)i)).collect(Collectors.toList());
        }

        public static MultiItemDataBuilder builder() {
            return new MultiItemDataBuilder();
        }

        public List<String> getRawItems() {
            return this.rawItems;
        }

        public void setRawItems(List<String> rawItems) {
            this.rawItems = rawItems;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiItemData)) {
                return false;
            }
            MultiItemData other = (MultiItemData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$rawItems = this.getRawItems();
            List<String> other$rawItems = other.getRawItems();
            return !(this$rawItems == null ? other$rawItems != null : !((Object)this$rawItems).equals(other$rawItems));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiItemData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $rawItems = this.getRawItems();
            result = result * 59 + ($rawItems == null ? 43 : ((Object)$rawItems).hashCode());
            return result;
        }

        public String toString() {
            return "MultiItem.MultiItemData(rawItems=" + this.getRawItems() + ")";
        }

        public MultiItemData() {
        }

        public MultiItemData(List<String> rawItems) {
            this.rawItems = rawItems;
        }

        static {
            IBootstrap.dasBoot();
        }

        public static class MultiItemDataBuilder {
            private ArrayList<String> rawItems;

            MultiItemDataBuilder() {
            }

            public MultiItemDataBuilder rawItem(String rawItem) {
                if (this.rawItems == null) {
                    this.rawItems = new ArrayList();
                }
                this.rawItems.add(rawItem);
                return this;
            }

            public MultiItemDataBuilder rawItems(Collection<? extends String> rawItems) {
                if (rawItems == null) {
                    throw new NullPointerException("rawItems cannot be null");
                }
                if (this.rawItems == null) {
                    this.rawItems = new ArrayList();
                }
                this.rawItems.addAll(rawItems);
                return this;
            }

            public MultiItemDataBuilder clearRawItems() {
                if (this.rawItems != null) {
                    this.rawItems.clear();
                }
                return this;
            }

            public MultiItemData build() {
                return new MultiItemData(switch (this.rawItems == null ? 0 : this.rawItems.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.rawItems.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<String>(this.rawItems));
                });
            }

            public String toString() {
                return "MultiItem.MultiItemData.MultiItemDataBuilder(rawItems=" + this.rawItems + ")";
            }

            static {
                IBootstrap.dasBoot();
            }
        }
    }
}

