/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ResidenceProtector
implements Protector {
    public ResidenceProtector() {
        FlagPermissions.addFlag((String)"use-adaptations");
    }

    @Override
    public boolean checkRegion(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, location, "use-adaptations");
    }

    @Override
    public boolean canBlockBreak(Player player, Location blockLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, blockLocation, adaptation) && this.checkPerm(player, blockLocation, Flags.destroy);
    }

    @Override
    public boolean canBlockPlace(Player player, Location blockLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, blockLocation, adaptation) && this.checkPerm(player, blockLocation, Flags.place);
    }

    @Override
    public boolean canPVP(Player player, Location entityLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, entityLocation, adaptation) && this.checkPerm(player, entityLocation, Flags.pvp);
    }

    @Override
    public boolean canPVE(Player player, Location entityLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, entityLocation, adaptation) && this.checkPerm(player, entityLocation, Flags.damage);
    }

    @Override
    public boolean canInteract(Player player, Location targetLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, targetLocation, adaptation) && this.checkPerm(player, targetLocation, Flags.use);
    }

    @Override
    public boolean canAccessChest(Player player, Location chestLocation, Adaptation<?> adaptation) {
        return this.checkRegion(player, chestLocation, adaptation) && this.checkPerm(player, chestLocation, Flags.container);
    }

    private boolean checkPerm(Player player, Location location, Flags flag) {
        ClaimedResidence res;
        if (!Residence.getInstance().isDisabledWorld(location.getWorld()) && (res = Residence.getInstance().getResidenceManager().getByLoc(location)) != null) {
            return res.getPermissions().playerHas(player.getName(), flag, true);
        }
        return true;
    }

    private boolean checkPerm(Player player, Location location, String flag) {
        ClaimedResidence res;
        if (!Residence.getInstance().isDisabledWorld(location.getWorld()) && (res = Residence.getInstance().getResidenceManager().getByLoc(location)) != null) {
            return res.getPermissions().playerHas(player.getName(), flag, true);
        }
        return true;
    }

    @Override
    public String getName() {
        return "Residence";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isResidence();
    }

    static {
        IBootstrap.dasBoot();
    }
}

