/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.agility.AgilityArmorUp;
import com.volmit.adapt.content.adaptation.agility.AgilitySuperJump;
import com.volmit.adapt.content.adaptation.agility.AgilityWallJump;
import com.volmit.adapt.content.adaptation.agility.AgilityWindUp;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;

public class SkillAgility
extends SimpleSkill<Config> {
    private Map<UUID, Location> lastLocations;

    public SkillAgility() {
        super("agility", Localizer.dLocalize("skill", "agility", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "agility", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "agility", "name"));
        this.setColor(C.GREEN);
        this.setInterval(975L);
        this.setIcon(Material.FEATHER);
        this.registerAdaptation(new AgilityWindUp());
        this.registerAdaptation(new AgilityWallJump());
        this.registerAdaptation(new AgilitySuperJump());
        this.registerAdaptation(new AgilityArmorUp());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.LEATHER_BOOTS).key("challenge_move_1k").title(Localizer.dLocalize("advancement", "challenge_move_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_move_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_BOOTS).key("challenge_sprint_5k").title(Localizer.dLocalize("advancement", "challenge_sprint_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_sprint_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_BOOTS).key("challenge_sprint_50k").title(Localizer.dLocalize("advancement", "challenge_sprint_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_sprint_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHERITE_BOOTS).key("challenge_sprint_500k").title(Localizer.dLocalize("advancement", "challenge_sprint_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_sprint_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).child(AdaptAdvancement.builder().icon(Material.GOLDEN_BOOTS).key("challenge_sprint_marathon").title(Localizer.dLocalize("advancement", "challenge_sprint_marathon", "title")).description(Localizer.dLocalize("advancement", "challenge_sprint_marathon", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_move_1k").goal(1000.0).stat("move").reward(((Config)this.getConfig()).challengeMove1kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_sprint_5k").goal(5000.0).stat("move").reward(((Config)this.getConfig()).challengeSprint5kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_sprint_50k").goal(50000.0).stat("move").reward(((Config)this.getConfig()).challengeSprint5kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_sprint_500k").goal(500000.0).stat("move").reward(((Config)this.getConfig()).challengeSprint5kReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_sprint_marathon").goal(42195.0).stat("move").reward(((Config)this.getConfig()).challengeSprintMarathonReward).build());
        this.lastLocations = new HashMap<UUID, Location>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getFrom().getWorld() != null && e.getTo() != null && e.getFrom().getWorld().equals(e.getTo().getWorld())) {
                double d = e.getFrom().distance(e.getTo());
                AdaptPlayer adaptPlayer = this.getPlayer(p);
                adaptPlayer.getData().addStat("move", d);
                if (p.isSneaking()) {
                    adaptPlayer.getData().addStat("move.sneak", d);
                } else if (p.isFlying()) {
                    adaptPlayer.getData().addStat("move.fly", d);
                } else if (p.isSwimming()) {
                    adaptPlayer.getData().addStat("move.swim", d);
                } else if (p.isSprinting()) {
                    adaptPlayer.getData().addStat("move.sprint", d);
                }
                this.xpSilent(p, ((Config)this.getConfig()).moveXpPassive * d);
            }
        });
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(i, () -> {
                this.checkStatTrackers(this.getPlayer(i));
                if (i.isSprinting() && !i.isFlying() && !i.isSwimming() && !i.isSneaking()) {
                    this.xpSilent(i, ((Config)this.getConfig()).sprintXpPassive);
                }
                if (i.isSwimming() && !i.isFlying() && !i.isSprinting() && !i.isSneaking()) {
                    this.xpSilent(i, ((Config)this.getConfig()).swimXpPassive);
                }
                if (i.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType().isAir() && !i.isFlying() && !i.isSneaking()) {
                    this.xpSilent(i, ((Config)this.getConfig()).jumpXpPassive);
                }
                if (i.getLocation().getBlock().getType() == Material.LADDER && !i.isFlying() && !i.isSneaking()) {
                    this.xpSilent(i, ((Config)this.getConfig()).climbXpPassive);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double challengeMove1kReward = 500.0;
        double challengeSprint5kReward = 2000.0;
        double challengeSprintMarathonReward = 6500.0;
        double sprintXpPassive = 1.25;
        double swimXpPassive = 1.25;
        double jumpXpPassive = 0.25;
        double climbXpPassive = 1.25;
        double moveXpPassive = 0.1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

