/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.brewing.BrewingAbsorption;
import com.volmit.adapt.content.adaptation.brewing.BrewingBlindness;
import com.volmit.adapt.content.adaptation.brewing.BrewingDarkness;
import com.volmit.adapt.content.adaptation.brewing.BrewingDecay;
import com.volmit.adapt.content.adaptation.brewing.BrewingFatigue;
import com.volmit.adapt.content.adaptation.brewing.BrewingHaste;
import com.volmit.adapt.content.adaptation.brewing.BrewingHealthBoost;
import com.volmit.adapt.content.adaptation.brewing.BrewingHunger;
import com.volmit.adapt.content.adaptation.brewing.BrewingLingering;
import com.volmit.adapt.content.adaptation.brewing.BrewingNausea;
import com.volmit.adapt.content.adaptation.brewing.BrewingResistance;
import com.volmit.adapt.content.adaptation.brewing.BrewingSaturation;
import com.volmit.adapt.content.adaptation.brewing.BrewingSuperHeated;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.content.matter.BrewingStandOwnerMatter;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;

public class SkillBrewing
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillBrewing() {
        super("brewing", Localizer.dLocalize("skill", "brewing", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.LIGHT_PURPLE);
        this.setDescription(Localizer.dLocalize("skill", "brewing", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "brewing", "name"));
        this.setInterval(5851L);
        this.setIcon(Material.LINGERING_POTION);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new BrewingLingering());
        this.registerAdaptation(new BrewingSuperHeated());
        this.registerAdaptation(new BrewingAbsorption());
        this.registerAdaptation(new BrewingBlindness());
        this.registerAdaptation(new BrewingDarkness());
        this.registerAdaptation(new BrewingDecay());
        this.registerAdaptation(new BrewingFatigue());
        this.registerAdaptation(new BrewingHaste());
        this.registerAdaptation(new BrewingHealthBoost());
        this.registerAdaptation(new BrewingHunger());
        this.registerAdaptation(new BrewingNausea());
        this.registerAdaptation(new BrewingResistance());
        this.registerAdaptation(new BrewingSaturation());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_1k").title(Localizer.dLocalize("advancement", "challenge_brew_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_5k").title(Localizer.dLocalize("advancement", "challenge_brew_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_50k").title(Localizer.dLocalize("advancement", "challenge_brew_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_500k").title(Localizer.dLocalize("advancement", "challenge_brew_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_5m").title(Localizer.dLocalize("advancement", "challenge_brew_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_1k").goal(1000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_5k").goal(5000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_50k").goal(50000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_500k").goal(500000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_5m").goal(5000000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_1k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_5k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_50k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_500k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_5m").title(Localizer.dLocalize("advancement", "challenge_brewsplash_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_1k").goal(1000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_5k").goal(5000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_50k").goal(50000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_500k").goal(500000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_5m").goal(5000000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        SpatialMatter.registerSliceType(new BrewingStandOwnerMatter());
    }

    private void handleCooldown(Player p, Runnable runnable) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        runnable.run();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerItemConsumeEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            ItemMeta patt11808$temp = e.getItem().getItemMeta();
            if (patt11808$temp instanceof PotionMeta) {
                PotionMeta o = (PotionMeta)patt11808$temp;
                if (!(e.getItem().toString().contains("potion-type=minecraft:water") || e.getItem().toString().contains("potion-type=minecraft:mundane") || e.getItem().toString().contains("potion-type=minecraft:thick") || e.getItem().toString().contains("potion-type=minecraft:awkward"))) {
                    this.getPlayer(p).getData().addStat("brewing.consumed", 1.0);
                    this.handleCooldown(p, () -> this.xp(p, p.getLocation(), ((Config)this.getConfig()).splashXP + ((Config)this.getConfig()).splashMultiplier * o.getCustomEffects().stream().mapToDouble(i -> (double)(i.getAmplifier() + 1) * ((double)i.getDuration() / 20.0)).sum() + ((Config)this.getConfig()).splashMultiplier * (double)(o.getBasePotionData().isUpgraded() ? 50 : 25)));
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PotionSplashEvent e) {
        ProjectileSource projectileSource = e.getPotion().getShooter();
        if (projectileSource instanceof Player) {
            Player p = (Player)projectileSource;
            this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
                AdaptPlayer a = this.getPlayer(p);
                this.getPlayer(p).getData().addStat("brewing.splashes", 1.0);
                this.xp(a.getPlayer(), e.getEntity().getLocation(), ((Config)this.getConfig()).splashXP + ((Config)this.getConfig()).splashMultiplier * e.getPotion().getEffects().stream().mapToDouble(i -> (double)(i.getAmplifier() + 1) * ((double)i.getDuration() / 20.0)).sum());
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPlaceEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
                WorldData.of(e.getBlock().getWorld()).getMantle().set(e.getBlock().getX(), e.getBlock().getY(), e.getBlock().getZ(), new BrewingStandOwner(e.getPlayer().getUniqueId()));
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
                WorldData.of(e.getBlock().getWorld()).getMantle().remove(e.getBlock().getX(), e.getBlock().getY(), e.getBlock().getZ(), BrewingStandOwner.class);
            }
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double challengeBrew1k = 1000.0;
        double challengeBrewSplash1k = 1000.0;
        double splashXP = 100.0;
        long cooldownDelay = 3250L;
        double splashMultiplier = 0.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

