/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.Discovery;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryArmor;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryUnity;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryVillagerAtt;
import com.volmit.adapt.content.adaptation.discovery.DiscoveryXpResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.potion.PotionEffect;

public class SkillDiscovery
extends SimpleSkill<Config> {
    public SkillDiscovery() {
        super("discovery", Localizer.dLocalize("skill", "discovery", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.AQUA);
        this.setDescription(Localizer.dLocalize("skill", "discovery", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "discovery", "name"));
        this.setInterval(500L);
        this.setIcon(Material.FILLED_MAP);
        this.registerAdaptation(new DiscoveryUnity());
        this.registerAdaptation(new DiscoveryArmor());
        this.registerAdaptation(new DiscoveryXpResist());
        this.registerAdaptation(new DiscoveryVillagerAtt());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerChangedWorldEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), () -> this.scheduleSeeWorld(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractAtEntityEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> this.seeEntity(e.getPlayer(), e.getRightClicked()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityPickupItemEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.seeItem(p, e.getItem().getItemStack()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CraftItemEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            try {
                NamespacedKey key = (NamespacedKey)Recipe.class.getDeclaredMethod("getKey()", new Class[0]).invoke((Object)e.getRecipe(), new Object[0]);
                if (key != null) {
                    this.seeCraftedRecipe(p, key.toString());
                }
            }
            catch (Throwable ignored) {
                Adapt.verbose("No recipe key found for " + e.getRecipe().getResult().getType().name());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerItemConsumeEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            this.seeItem(e.getPlayer(), e.getItem());
            this.seeFood(e.getPlayer(), e.getItem().getType());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getClickedBlock() != null) {
                this.seeBlock(e.getPlayer(), e.getClickedBlock().getBlockData(), e.getClickedBlock().getLocation());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerExpChangeEvent e) {
        this.shouldReturnForPlayer(e.getPlayer(), () -> {
            if (e.getAmount() > 0 && this.getLevel(e.getPlayer()) > 0) {
                this.xp(e.getPlayer(), e.getAmount());
            }
        });
    }

    private void scheduleSeeWorld(Player p) {
        try {
            J.a(() -> this.seeWorld(p, p.getWorld()), 15);
        }
        catch (Exception e) {
            Adapt.error("Failed to discover world " + p.getWorld().getName());
        }
    }

    public void seeBlock(Player p, BlockData bd, Location l) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenBlocks();
        if (d.isNewDiscovery(bd.getAsString())) {
            this.xp(p, ((Config)this.getConfig()).discoverBlockBaseXP + this.getValue(bd) * ((Config)this.getConfig()).discoverBlockValueXPMultiplier);
            if (((Config)this.getConfig()).showParticles) {
                p.spawnParticle(Particle.TOTEM, l.clone().add(0.5, 0.5, 0.5), 9, 0.0, 0.0, 0.0, 0.3);
            }
        }
        this.seeItem(p, bd.getMaterial());
    }

    public void seeItem(Player p, Material bd) {
        Discovery<Material> d = this.getPlayer(p).getData().getSeenItems();
        if (d.isNewDiscovery(bd)) {
            this.xp(p, ((Config)this.getConfig()).discoverItemBaseXP + this.getValue(bd) * ((Config)this.getConfig()).discoverItemValueXPMultiplier);
        }
    }

    public void seeItem(Player p, ItemStack bd) {
        this.seeItem(p, bd.getType());
        Map m = bd.getEnchantments();
        for (Enchantment i : m.keySet()) {
            this.seeEnchant(p, i, (Integer)m.get(i));
        }
    }

    public void seeCraftedRecipe(Player p, String key) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenRecipes();
        if (d.isNewDiscovery(key)) {
            this.xp(p, ((Config)this.getConfig()).discoverRecipeBaseXP);
        }
    }

    public void seeFood(Player p, Material bd) {
        Discovery<Material> d = this.getPlayer(p).getData().getSeenFoods();
        if (d.isNewDiscovery(bd)) {
            this.xp(p, ((Config)this.getConfig()).discoverFoodTypeXP);
        }
    }

    public void seeEntity(Player p, Entity bd) {
        Discovery<EntityType> d = this.getPlayer(p).getData().getSeenMobs();
        if (d.isNewDiscovery(bd.getType())) {
            this.xp(p, ((Config)this.getConfig()).discoverEntityTypeXP);
        }
        if (bd instanceof Player) {
            this.seePlayer(p, (Player)bd);
        }
        if (bd instanceof LivingEntity) {
            for (PotionEffect i : ((LivingEntity)bd).getActivePotionEffects()) {
                this.seePotionEffect(p, i);
            }
        }
    }

    public void seePlayer(Player p, Player bd) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenPeople();
        if (d.isNewDiscovery(bd.getUniqueId().toString())) {
            this.xp(p, ((Config)this.getConfig()).discoverPlayerXP);
        }
    }

    public void seeEnchant(Player p, Enchantment bd, int level) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenEnchants();
        if (d.isNewDiscovery(bd.getName() + " " + Form.toRoman(level))) {
            this.xp(p, ((Config)this.getConfig()).discoverEnchantBaseXP + Math.min(((Config)this.getConfig()).discoverEnchantMaxXP, (double)level * ((Config)this.getConfig()).discoverEnchantLevelXPMultiplier));
        }
    }

    public void seeWorld(Player p, World world) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenWorlds();
        if (d.isNewDiscovery(world.getName() + "-" + world.getSeed())) {
            this.xp(p, ((Config)this.getConfig()).discoverWorldXP);
        }
        this.seeEnvironment(p, world.getEnvironment());
    }

    public void seeEnvironment(Player p, World.Environment world) {
        Discovery<World.Environment> d = this.getPlayer(p).getData().getSeenEnvironments();
        if (d.isNewDiscovery(world)) {
            this.xp(p, ((Config)this.getConfig()).discoverEnvironmentXP);
        }
    }

    public void seePotionEffect(Player p, PotionEffect e) {
        Discovery<String> d = this.getPlayer(p).getData().getSeenPotionEffects();
        if (d.isNewDiscovery(e.getType().getName() + " " + Form.toRoman(e.getAmplifier()).trim())) {
            this.xp(p, ((Config)this.getConfig()).discoverPotionXP);
        }
    }

    public void seeBiome(Player p, Biome e) {
        Discovery<Biome> d = this.getPlayer(p).getData().getSeenBiomes();
        if (d.isNewDiscovery(e)) {
            this.xp(p, ((Config)this.getConfig()).discoverBiomeXP);
        }
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player i : Bukkit.getOnlinePlayers()) {
            if (this.shouldReturnForPlayer(i)) continue;
            this.seeTargetBlock(i);
        }
    }

    private void seeTargetBlock(Player i) {
        try {
            Block b = i.getTargetBlockExact(5, FluidCollisionMode.NEVER);
            if (b != null) {
                this.seeBlock(i, b.getBlockData(), b.getLocation());
                this.seeBiome(i, b.getBiome());
            }
        }
        catch (Throwable ignored) {
            Adapt.verbose("Failed to get target block for " + i.getName());
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean showParticles = true;
        double discoverBiomeXP = 15.0;
        double discoverPotionXP = 36.0;
        double discoverEntityTypeXP = 125.0;
        double discoverFoodTypeXP = 75.0;
        double discoverPlayerXP = 125.0;
        double discoverEnvironmentXP = 750.0;
        double discoverWorldXP = 750.0;
        double discoverEnchantMaxXP = 250.0;
        double discoverEnchantLevelXPMultiplier = 52.0;
        double discoverEnchantBaseXP = 5.0;
        double discoverItemBaseXP = 10.0;
        double discoverRecipeBaseXP = 15.0;
        double discoverItemValueXPMultiplier = 1.0;
        double discoverBlockBaseXP = 3.0;
        double discoverBlockValueXPMultiplier = 0.333;

        static {
            IBootstrap.dasBoot();
        }
    }
}

