/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.excavation.ExcavationDropToInventory;
import com.volmit.adapt.content.adaptation.excavation.ExcavationHaste;
import com.volmit.adapt.content.adaptation.excavation.ExcavationOmniTool;
import com.volmit.adapt.content.adaptation.excavation.ExcavationSpelunker;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillExcavation
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillExcavation() {
        super("excavation", Localizer.dLocalize("skill", "excavation", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "excavation", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "excavation", "name"));
        this.setColor(C.YELLOW);
        this.setInterval(5953L);
        this.setIcon(Material.DIAMOND_SHOVEL);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new ExcavationHaste());
        this.registerAdaptation(new ExcavationSpelunker());
        this.registerAdaptation(new ExcavationOmniTool());
        this.registerAdaptation(new ExcavationDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_SHOVEL).key("challenge_excavate_1k").title(Localizer.dLocalize("advancement", "challenge_excavate_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.KNOWLEDGE_BOOK).key("challenge_excavate_5k").title(Localizer.dLocalize("advancement", "challenge_excavate_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_SHOVEL).key("challenge_excavate_50k").title(Localizer.dLocalize("advancement", "challenge_excavate_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_SHOVEL).key("challenge_excavate_500k").title(Localizer.dLocalize("advancement", "challenge_excavate_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_SHOVEL).key("challenge_excavate_5m").title(Localizer.dLocalize("advancement", "challenge_excavate_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_excavate_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_1k").goal(1000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_5k").goal(5000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_50k").goal(50000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_enchant_500k").goal(500000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_excavate_5m").goal(5000000.0).stat("excavation.blocks.broken").reward(((Config)this.getConfig()).challengeExcavationReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (this.checkValidEntity(e.getEntity().getType())) {
                if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
                    return;
                }
                this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.handleEntityDamageByPlayer(p, e));
            }
        }
    }

    private void handleEntityDamageByPlayer(Player p, EntityDamageByEntityEvent e) {
        AdaptPlayer a = this.getPlayer(p);
        ItemStack hand = a.getPlayer().getInventory().getItemInMainHand();
        if (this.isShovel(hand)) {
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            this.getPlayer(p).getData().addStat("excavation.swings", 1.0);
            this.getPlayer(p).getData().addStat("excavation.damage", e.getDamage());
            this.xp(a.getPlayer(), e.getEntity().getLocation(), ((Config)this.getConfig()).axeDamageXPMultiplier * e.getDamage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (this.isShovel(p.getInventory().getItemInMainHand())) {
                this.handleBlockBreakWithShovel(p, e);
            }
        });
    }

    private void handleBlockBreakWithShovel(Player p, BlockBreakEvent e) {
        this.getPlayer(p).getData().addStat("excavation.blocks.broken", 1.0);
        this.getPlayer(p).getData().addStat("excavation.blocks.value", this.getValue(e.getBlock().getBlockData()));
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        double v = this.getValue(e.getBlock().getType());
        this.xp(p, e.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), this.blockXP(e.getBlock(), v));
    }

    @Override
    public double getValue(Material type) {
        double value = super.getValue(type) * ((Config)this.getConfig()).valueXPMultiplier;
        value += Math.min(((Config)this.getConfig()).maxHardnessBonus, (double)type.getHardness());
        return value += Math.min(((Config)this.getConfig()).maxBlastResistanceBonus, (double)type.getBlastResistance());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double challengeExcavationReward = 1200.0;
        double valueXPMultiplier = 0.825;
        long cooldownDelay = 1250L;
        double axeDamageXPMultiplier = 6.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

