/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.nether.NetherFireResist;
import com.volmit.adapt.content.adaptation.nether.NetherSkullYeet;
import com.volmit.adapt.content.adaptation.nether.NetherWitherResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class SkillNether
extends SimpleSkill<Config> {
    private int witherRoseCooldown;

    public SkillNether() {
        super("nether", Localizer.dLocalize("skill", "nether", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "nether", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "nether", "name"));
        this.setInterval(7425L);
        this.setColor(C.DARK_GRAY);
        this.setIcon(Material.NETHER_STAR);
        this.registerAdaptation(new NetherWitherResist());
        this.registerAdaptation(new NetherSkullYeet());
        this.registerAdaptation(new NetherFireResist());
    }

    private boolean shouldReturnForEventWithCause(Player p, EntityDamageEvent.DamageCause cause) {
        return this.shouldReturnForPlayer(p) || cause != EntityDamageEvent.DamageCause.WITHER;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageEvent e) {
        Player p;
        Entity entity;
        if (!this.isEnabled() || e.isCancelled() || !((entity = e.getEntity()) instanceof Player) || this.shouldReturnForEventWithCause(p = (Player)entity, e.getCause()) || e instanceof EntityDamageByBlockEvent) {
            return;
        }
        this.xp(p, ((Config)this.getConfig()).getWitherDamageXp());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (e.getBlock().getType() == Material.WITHER_ROSE && this.witherRoseCooldown == 0) {
                this.witherRoseCooldown = ((Config)this.getConfig()).getWitherRoseBreakCooldown();
                this.xp(p, e.getBlock().getLocation().add(0.5, 0.5, 0.5), ((Config)this.getConfig()).getWitherRoseBreakXp());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDeathEvent e) {
        Player p = e.getEntity().getKiller();
        if (p == null || !p.getClass().getSimpleName().equals("CraftPlayer") || this.shouldReturnForPlayer(p)) {
            return;
        }
        if (e.getEntityType() == EntityType.WITHER_SKELETON) {
            this.xp(p, ((Config)this.getConfig()).getWitherSkeletonKillXp());
        } else if (e.getEntityType() == EntityType.WITHER) {
            this.xp(p, ((Config)this.getConfig()).getWitherKillXp());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getDamager();
        if (!(entity instanceof Player) || this.shouldReturnForEventWithCause(p = (Player)entity, e.getCause())) {
            return;
        }
        this.xp(p, ((Config)this.getConfig()).getWitherAttackXp());
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.witherRoseCooldown > 0) {
            --this.witherRoseCooldown;
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).isEnabled();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        private boolean enabled = true;
        private double witherDamageXp = 26.0;
        private double witherAttackXp = 15.0;
        private double witherSkeletonKillXp = 325.0;
        private double witherKillXp = 1250.0;
        private double witherRoseBreakXp = 125.0;
        private int witherRoseBreakCooldown = 1200;

        public boolean isEnabled() {
            return this.enabled;
        }

        public double getWitherDamageXp() {
            return this.witherDamageXp;
        }

        public double getWitherAttackXp() {
            return this.witherAttackXp;
        }

        public double getWitherSkeletonKillXp() {
            return this.witherSkeletonKillXp;
        }

        public double getWitherKillXp() {
            return this.witherKillXp;
        }

        public double getWitherRoseBreakXp() {
            return this.witherRoseBreakXp;
        }

        public int getWitherRoseBreakCooldown() {
            return this.witherRoseBreakCooldown;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setWitherDamageXp(double witherDamageXp) {
            this.witherDamageXp = witherDamageXp;
        }

        public void setWitherAttackXp(double witherAttackXp) {
            this.witherAttackXp = witherAttackXp;
        }

        public void setWitherSkeletonKillXp(double witherSkeletonKillXp) {
            this.witherSkeletonKillXp = witherSkeletonKillXp;
        }

        public void setWitherKillXp(double witherKillXp) {
            this.witherKillXp = witherKillXp;
        }

        public void setWitherRoseBreakXp(double witherRoseBreakXp) {
            this.witherRoseBreakXp = witherRoseBreakXp;
        }

        public void setWitherRoseBreakCooldown(int witherRoseBreakCooldown) {
            this.witherRoseBreakCooldown = witherRoseBreakCooldown;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (Double.compare(this.getWitherDamageXp(), other.getWitherDamageXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherAttackXp(), other.getWitherAttackXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherSkeletonKillXp(), other.getWitherSkeletonKillXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherKillXp(), other.getWitherKillXp()) != 0) {
                return false;
            }
            if (Double.compare(this.getWitherRoseBreakXp(), other.getWitherRoseBreakXp()) != 0) {
                return false;
            }
            return this.getWitherRoseBreakCooldown() == other.getWitherRoseBreakCooldown();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            long $witherDamageXp = Double.doubleToLongBits(this.getWitherDamageXp());
            result = result * 59 + (int)($witherDamageXp >>> 32 ^ $witherDamageXp);
            long $witherAttackXp = Double.doubleToLongBits(this.getWitherAttackXp());
            result = result * 59 + (int)($witherAttackXp >>> 32 ^ $witherAttackXp);
            long $witherSkeletonKillXp = Double.doubleToLongBits(this.getWitherSkeletonKillXp());
            result = result * 59 + (int)($witherSkeletonKillXp >>> 32 ^ $witherSkeletonKillXp);
            long $witherKillXp = Double.doubleToLongBits(this.getWitherKillXp());
            result = result * 59 + (int)($witherKillXp >>> 32 ^ $witherKillXp);
            long $witherRoseBreakXp = Double.doubleToLongBits(this.getWitherRoseBreakXp());
            result = result * 59 + (int)($witherRoseBreakXp >>> 32 ^ $witherRoseBreakXp);
            result = result * 59 + this.getWitherRoseBreakCooldown();
            return result;
        }

        public String toString() {
            return "SkillNether.Config(enabled=" + this.isEnabled() + ", witherDamageXp=" + this.getWitherDamageXp() + ", witherAttackXp=" + this.getWitherAttackXp() + ", witherSkeletonKillXp=" + this.getWitherSkeletonKillXp() + ", witherKillXp=" + this.getWitherKillXp() + ", witherRoseBreakXp=" + this.getWitherRoseBreakXp() + ", witherRoseBreakCooldown=" + this.getWitherRoseBreakCooldown() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

