/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeAutosmelt;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeChisel;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeDropToInventory;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeVeinminer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillPickaxes
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillPickaxes() {
        super("pickaxe", Localizer.dLocalize("skill", "pickaxe", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "pickaxe", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "pickaxe", "name"));
        this.setColor(C.GOLD);
        this.setInterval(2750L);
        this.setIcon(Material.NETHERITE_PICKAXE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new PickaxeChisel());
        this.registerAdaptation(new PickaxeVeinminer());
        this.registerAdaptation(new PickaxeAutosmelt());
        this.registerAdaptation(new PickaxeDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_PICKAXE).key("challenge_pickaxe_1k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_PICKAXE).key("challenge_pickaxe_5k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_PICKAXE).key("challenge_pickaxe_50k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_PICKAXE).key("challenge_pickaxe_500k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHERITE_PICKAXE).key("challenge_pickaxe_5m").title(Localizer.dLocalize("advancement", "challenge_pickaxe_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_1k").goal(100.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 2.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_5k").goal(500.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 5.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_50k").goal(5000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_500k").goal(50000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_5m").goal(500000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 50.0).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Player player = p = e.getDamager() instanceof Player ? (Player)e.getDamager() : null;
        if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
            return;
        }
        this.shouldReturnForPlayer(p, () -> {
            if (this.checkValidEntity(e.getEntity().getType())) {
                AdaptPlayer a = this.getPlayer(p);
                ItemStack hand = p.getInventory().getItemInMainHand();
                if (this.isPickaxe(hand)) {
                    a.getData().addStat("pickaxe.swings", 1.0);
                    a.getData().addStat("pickaxe.damage", e.getDamage());
                    this.handleCooldown(p, () -> this.xp(p, e.getEntity().getLocation(), ((Config)this.getConfig()).damageXPMultiplier * e.getDamage()));
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(p, () -> {
            ItemStack mainHand = p.getInventory().getItemInMainHand();
            if (this.isPickaxe(mainHand)) {
                Material blockType = e.getBlock().getType();
                double blockValue = this.getValue(blockType);
                AdaptPlayer adaptPlayer = this.getPlayer(p);
                adaptPlayer.getData().addStat("pickaxe.blocks.broken", 1.0);
                adaptPlayer.getData().addStat("pickaxe.blocks.value", blockValue);
                this.handleCooldown(p, () -> {
                    if (mainHand.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
                        this.xp(p, 5.0);
                    } else {
                        Location blockLocation = e.getBlock().getLocation().clone().add(0.5, 0.5, 0.5);
                        J.a(() -> this.xp(p, blockLocation, this.blockXP(e.getBlock(), blockValue)));
                    }
                });
            }
        });
    }

    @Override
    public double getValue(Material type) {
        Config c = (Config)this.getConfig();
        double value = super.getValue(type) * c.blockValueMultiplier;
        value += Math.min(c.maxHardnessBonus, (double)type.getHardness());
        value += Math.min(c.maxBlastResistanceBonus, (double)type.getBlastResistance());
        return (value += (switch (type) {
            case Material.COAL_ORE -> c.coalBonus;
            case Material.COPPER_ORE -> c.copperBonus;
            case Material.IRON_ORE -> c.ironBonus;
            case Material.GOLD_ORE -> c.goldBonus;
            case Material.LAPIS_ORE -> c.lapisBonus;
            case Material.DIAMOND_ORE -> c.diamondBonus;
            case Material.EMERALD_ORE -> c.emeraldBonus;
            case Material.NETHER_GOLD_ORE -> c.netherGoldBonus;
            case Material.NETHER_QUARTZ_ORE -> c.netherQuartzBonus;
            case Material.REDSTONE_ORE -> c.redstoneBonus;
            case Material.ANCIENT_DEBRIS -> c.debrisBonus;
            case Material.DEEPSLATE_COAL_ORE -> c.coalBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_COPPER_ORE -> c.copperBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_IRON_ORE -> c.ironBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_GOLD_ORE -> c.goldBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_LAPIS_ORE -> c.lapisBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_DIAMOND_ORE -> c.diamondBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_EMERALD_ORE -> c.emeraldBonus * c.deepslateMultiplier;
            case Material.DEEPSLATE_REDSTONE_ORE -> c.redstoneBonus * c.deepslateMultiplier;
            default -> 0.0;
        })) * 0.48;
    }

    private void handleCooldown(Player p, Runnable action) {
        if (this.cooldowns.containsKey(p)) {
            if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(p);
        }
        this.cooldowns.put(p, System.currentTimeMillis());
        action.run();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public double debrisBonus = 300.0;
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double damageXPMultiplier = 13.26;
        double blockValueMultiplier = 0.125;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double coalBonus = 25.0;
        double ironBonus = 40.0;
        double redstoneBonus = 75.0;
        double copperBonus = 30.0;
        double goldBonus = 50.0;
        double lapisBonus = 105.0;
        long cooldownDelay = 1250L;
        double diamondBonus = 250.0;
        double emeraldBonus = 300.0;
        double netherGoldBonus = 150.0;
        double netherQuartzBonus = 175.0;
        double deepslateMultiplier = 1.35;

        static {
            IBootstrap.dasBoot();
        }
    }
}

