/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.ranged.RangedArrowRecovery;
import com.volmit.adapt.content.adaptation.ranged.RangedForce;
import com.volmit.adapt.content.adaptation.ranged.RangedLungeShot;
import com.volmit.adapt.content.adaptation.ranged.RangedPiercing;
import com.volmit.adapt.content.adaptation.ranged.RangedWebBomb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class SkillRanged
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillRanged() {
        super("ranged", Localizer.dLocalize("skill", "ranged", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "ranged", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "ranged", "name"));
        this.setColor(C.DARK_GREEN);
        this.setInterval(3044L);
        this.registerAdaptation(new RangedForce());
        this.registerAdaptation(new RangedPiercing());
        this.registerAdaptation(new RangedArrowRecovery());
        this.registerAdaptation(new RangedLungeShot());
        this.registerAdaptation(new RangedWebBomb());
        this.setIcon(Material.CROSSBOW);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(ProjectileLaunchEvent e) {
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getEntity() instanceof Snowball || e.getEntity() instanceof EntityFishingHook) {
                return;
            }
            this.getPlayer(p).getData().addStat("ranged.shotsfired", 1.0);
            this.getPlayer(p).getData().addStat("ranged.shotsfired." + e.getEntity().getType().name().toLowerCase(Locale.ROOT), 1.0);
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            this.xp(p, ((Config)this.getConfig()).shootXP);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        block3: {
            block2: {
                ProjectileSource projectileSource;
                if (!(e.getDamager() instanceof Projectile) || !((projectileSource = ((Projectile)e.getDamager()).getShooter()) instanceof Player)) break block2;
                p = (Player)projectileSource;
                if (this.checkValidEntity(e.getEntity().getType())) break block3;
            }
            return;
        }
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getEntity() instanceof Snowball || e.getEntity() instanceof EntityFishingHook) {
                return;
            }
            this.getPlayer(p).getData().addStat("ranged.damage", e.getDamage());
            this.getPlayer(p).getData().addStat("ranged.distance", e.getEntity().getLocation().distance(p.getLocation()));
            this.getPlayer(p).getData().addStat("ranged.damage." + e.getDamager().getType().name().toLowerCase(Locale.ROOT), e.getDamage());
            this.getPlayer(p).getData().addStat("ranged.distance." + e.getDamager().getType().name().toLowerCase(Locale.ROOT), e.getEntity().getLocation().distance(p.getLocation()));
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            this.xp(p, e.getEntity().getLocation(), ((Config)this.getConfig()).hitDamageXPMultiplier * e.getDamage() + e.getEntity().getLocation().distance(p.getLocation()) * ((Config)this.getConfig()).hitDistanceXPMultiplier);
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double shootXP = 5.0;
        long cooldownDelay = 1250L;
        double hitDamageXPMultiplier = 2.125;
        double hitDistanceXPMultiplier = 1.7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

