/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.content.adaptation.rift.RiftAccess;
import com.volmit.adapt.content.adaptation.rift.RiftBlink;
import com.volmit.adapt.content.adaptation.rift.RiftDescent;
import com.volmit.adapt.content.adaptation.rift.RiftEnderchest;
import com.volmit.adapt.content.adaptation.rift.RiftGate;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemEnderEye;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.projectiles.ProjectileSource;

public class SkillRift
extends SimpleSkill<Config> {
    private final Map<Player, Long> lasttp;

    public SkillRift() {
        super("rift", Localizer.dLocalize("skill", "rift", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "rift", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "rift", "name"));
        this.setColor(C.DARK_PURPLE);
        this.setInterval(1154L);
        this.setIcon(Material.ENDER_EYE);
        this.registerAdaptation(new RiftResist());
        this.registerAdaptation(new RiftAccess());
        this.registerAdaptation(new RiftEnderchest());
        this.registerAdaptation(new RiftGate());
        this.registerAdaptation(new RiftBlink());
        this.registerAdaptation(new RiftDescent());
        this.lasttp = new HashMap<Player, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        this.shouldReturnForPlayer(e.getPlayer(), (Cancellable)e, () -> {
            if (!this.lasttp.containsKey(p)) {
                this.xpSilent(p, ((Config)this.getConfig()).teleportXP);
                this.lasttp.put(p, M.ms());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(ProjectileLaunchEvent e) {
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player p = (Player)projectileSource;
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getEntity() instanceof EnderPearl) {
                this.xp(p, ((Config)this.getConfig()).throwEnderpearlXP);
            } else if (e.getEntity() instanceof ItemEnderEye) {
                this.xp(p, ((Config)this.getConfig()).throwEnderEyeXP);
            }
        });
    }

    private void handleEntityDamageByEntity(Entity entity, Player p, double damage) {
        if (entity instanceof Enderman) {
            this.xp(p, ((Config)this.getConfig()).damageEndermanXPMultiplier * Math.min(damage, ((Enderman)entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
        } else if (entity instanceof Endermite) {
            this.xp(p, ((Config)this.getConfig()).damageEndermiteXPMultiplier * Math.min(damage, ((Endermite)entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
        } else if (entity instanceof EnderDragon) {
            this.xp(p, ((Config)this.getConfig()).damageEnderdragonXPMultiplier * Math.min(damage, ((EnderDragon)entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
        } else if (entity instanceof EnderCrystal) {
            this.xp(p, ((Config)this.getConfig()).damageEndCrystalXP);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.handleEntityDamageByEntity(e.getEntity(), p, e.getDamage()));
        } else {
            Projectile j;
            entity = e.getDamager();
            if (entity instanceof Projectile && (entity = (j = (Projectile)entity).getShooter()) instanceof Player) {
                Player p = (Player)entity;
                this.shouldReturnForPlayer(p, (Cancellable)e, () -> this.handleEntityDamageByEntity(e.getEntity(), p, e.getDamage()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDeathEvent e) {
        if (e.getEntity() instanceof EnderCrystal && e.getEntity().getKiller() != null) {
            Player p = e.getEntity().getKiller();
            this.shouldReturnForPlayer(p, () -> this.xp(e.getEntity().getKiller(), ((Config)this.getConfig()).destroyEndCrystalXP));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.lasttp.remove(p);
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player i : XMap.k(this.lasttp)) {
            this.shouldReturnForPlayer(i, () -> {
                if ((double)(M.ms() - this.lasttp.get(i)) > ((Config)this.getConfig()).teleportXPCooldown) {
                    this.lasttp.remove(i);
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double destroyEndCrystalXP = 350.0;
        double damageEndCrystalXP = 110.0;
        double damageEndermanXPMultiplier = 4.0;
        double damageEndermiteXPMultiplier = 2.0;
        double damageEnderdragonXPMultiplier = 8.0;
        double throwEnderpearlXP = 105.0;
        double throwEnderEyeXP = 45.0;
        double teleportXP = 15.0;
        double teleportXPCooldown = 60000.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

