/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.content.adaptation.tragoul.TragoulGlobe;
import com.volmit.adapt.content.adaptation.tragoul.TragoulHealing;
import com.volmit.adapt.content.adaptation.tragoul.TragoulLance;
import com.volmit.adapt.content.adaptation.tragoul.TragoulThorns;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.CloudEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class SkillTragOul
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillTragOul() {
        super("tragoul", Localizer.dLocalize("skill", "tragoul", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.AQUA);
        this.setDescription(Localizer.dLocalize("skill", "tragoul", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "tragoul", "name"));
        this.setInterval(2755L);
        this.setIcon(Material.CRIMSON_ROOTS);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new TragoulThorns());
        this.registerAdaptation(new TragoulGlobe());
        this.registerAdaptation(new TragoulHealing());
        this.registerAdaptation(new TragoulLance());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getEntity().isDead() || e.getEntity().isInvulnerable() || p.isInvulnerable() || p.isBlocking() || !this.checkValidEntity(e.getEntity().getType())) {
                return;
            }
            AdaptPlayer a = this.getPlayer(p);
            a.getData().addStat("trag.hitsrecieved", 1.0);
            a.getData().addStat("trag.damage", e.getDamage());
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            this.cooldowns.put(p, System.currentTimeMillis());
            this.xp(a.getPlayer(), ((Config)this.getConfig()).damageReceivedXpMultiplier * e.getDamage());
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerDeathEvent e) {
        Player p = e.getEntity();
        this.shouldReturnForPlayer(p, () -> {
            AdaptPlayer a = this.getPlayer(p);
            if (AdaptConfig.get().isHardcoreResetOnPlayerDeath()) {
                Adapt.info("Resetting " + p.getName() + "'s skills due to death");
                a.delete(p.getUniqueId());
                return;
            }
            if (((Config)this.getConfig()).takeAwaySkillsOnDeath) {
                if (((Config)this.getConfig()).showParticles) {
                    CloudEffect ce = new CloudEffect(Adapt.instance.adaptEffectManager);
                    ce.mainParticle = Particle.ASH;
                    ce.cloudParticle = Particle.REDSTONE;
                    ce.duration = 10000;
                    ce.iterations = 1000;
                    ce.setEntity((Entity)p);
                    ce.start();
                }
                if (this.hasBlacklistPermission(p, this)) {
                    return;
                }
                p.playSound(p.getLocation(), Sound.ENTITY_BLAZE_DEATH, 1.0f, 1.0f);
                PlayerSkillLine tragoul = a.getData().getSkillLines().get("tragoul");
                if (tragoul != null) {
                    double xp = tragoul.getXp();
                    if (xp > ((Config)this.getConfig()).deathXpLoss) {
                        this.xp(p, ((Config)this.getConfig()).deathXpLoss);
                    } else {
                        tragoul.setXp(0.0);
                    }
                    tragoul.setLastXP(xp);
                    for (PlayerAdaptation adapt : tragoul.getAdaptations().values()) {
                        adapt.setLevel(Math.max(adapt.getLevel() - 1, 0));
                    }
                    this.recalcTotalExp(p);
                }
            }
        });
    }

    @Override
    public void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        for (Player i : Bukkit.getOnlinePlayers()) {
            this.shouldReturnForPlayer(i, () -> {
                AdaptPlayer player = this.getPlayer(i);
                this.checkStatTrackers(player);
            });
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public double deathXpLoss = -750.0;
        boolean takeAwaySkillsOnDeath = false;
        boolean enabled = true;
        boolean showParticles = true;
        long cooldownDelay = 1000L;
        double damageReceivedXpMultiplier = 2.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

