/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.content.adaptation.unarmed.UnarmedGlassCannon;
import com.volmit.adapt.content.adaptation.unarmed.UnarmedPower;
import com.volmit.adapt.content.adaptation.unarmed.UnarmedSuckerPunch;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillUnarmed
extends SimpleSkill<Config> {
    public SkillUnarmed() {
        super("unarmed", Localizer.dLocalize("skill", "unarmed", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "unarmed", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "unarmed", "name"));
        this.setInterval(2579L);
        this.registerAdaptation(new UnarmedSuckerPunch());
        this.registerAdaptation(new UnarmedPower());
        this.registerAdaptation(new UnarmedGlassCannon());
        this.setIcon(Material.FIRE_CHARGE);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent e) {
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        this.shouldReturnForPlayer(p, (Cancellable)e, () -> {
            if (e.getEntity().isDead() || e.getEntity().isInvulnerable() || p.isInvulnerable()) {
                return;
            }
            if (!this.checkValidEntity(e.getEntity().getType())) {
                return;
            }
            AdaptPlayer a = this.getPlayer(p);
            ItemStack hand = a.getPlayer().getInventory().getItemInMainHand();
            if (!this.isMelee(hand)) {
                a.getData().addStat("unarmed.hits", 1.0);
                a.getData().addStat("unarmed.damage", e.getDamage());
                this.xp(a.getPlayer(), e.getEntity().getLocation(), ((Config)this.getConfig()).damageXPMultiplier * e.getDamage());
            }
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double damageXPMultiplier = 8.44;

        static {
            IBootstrap.dasBoot();
        }
    }
}

