/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.DoubleArrayUtils;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class Average {
    protected double[] values;
    protected int cursor;
    private double average;
    private double lastSum;
    private boolean dirty;
    private boolean brandNew;

    public Average(int size) {
        this.values = new double[size];
        DoubleArrayUtils.fill(this.values, 0.0);
        this.brandNew = true;
        this.average = 0.0;
        this.cursor = 0;
        this.lastSum = 0.0;
        this.dirty = false;
    }

    public void put(double i) {
        this.dirty = true;
        if (this.brandNew) {
            DoubleArrayUtils.fill(this.values, i);
            this.lastSum = (double)this.size() * i;
            this.brandNew = false;
            return;
        }
        double current = this.values[this.cursor];
        this.lastSum = this.lastSum - current + i;
        this.values[this.cursor] = i;
        this.cursor = this.cursor + 1 < this.size() ? this.cursor + 1 : 0;
    }

    public double getAverage() {
        if (this.dirty) {
            this.calculateAverage();
            return this.getAverage();
        }
        return this.average;
    }

    private void calculateAverage() {
        this.average = this.lastSum / (double)this.size();
        this.dirty = false;
    }

    public int size() {
        return this.values.length;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    static {
        IBootstrap.dasBoot();
    }
}

