/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class BurstExecutor {
    private final ExecutorService executor;
    private final List<CompletableFuture<Void>> futures;

    public BurstExecutor(ExecutorService executor, int burstSizeEstimate) {
        this.executor = executor;
        this.futures = new ArrayList<CompletableFuture<Void>>(burstSizeEstimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> queue(Runnable r) {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            CompletableFuture<Void> c = CompletableFuture.runAsync(r, this.executor);
            this.futures.add(c);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BurstExecutor queue(Runnable[] r) {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            for (Runnable i : r) {
                CompletableFuture<Void> c = CompletableFuture.runAsync(i, this.executor);
                this.futures.add(c);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        List<CompletableFuture<Void>> list = this.futures;
        synchronized (list) {
            try {
                CompletableFuture.allOf(this.futures.toArray(new CompletableFuture[this.futures.size()])).get();
                this.futures.clear();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        IBootstrap.dasBoot();
    }
}

