/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Callback;
import com.volmit.adapt.util.ChronoLatch;
import com.volmit.adapt.util.Contained;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Chunker<T> {
    private final List<T> q;
    private ExecutorService executor;
    private int threads;
    private int workload;

    public Chunker(List<T> q) {
        this.q = q;
    }

    public Chunker<T> threads(int threads) {
        this.threads = threads;
        return this;
    }

    public Chunker<T> workload(int workload) {
        this.workload = workload;
        return this;
    }

    public void execute(Consumer<T> consumer, Callback<Double> progress, int progressInterval) {
        int length;
        ChronoLatch cl = new ChronoLatch(progressInterval);
        Contained<Integer> consumed = new Contained<Integer>(0);
        this.executor = Executors.newFixedThreadPool(this.threads);
        int remaining = length = this.q.size();
        while (remaining > 0) {
            int at = remaining;
            int to = remaining -= remaining > this.workload ? this.workload : remaining;
            this.executor.submit(() -> {
                J.dofor(at, i -> i.compareTo(to) >= 0, -1, i -> J.attempt(() -> consumer.accept(this.q.get((int)i))));
                consumed.mod(c -> {
                    c = c + this.workload;
                    return c;
                });
                J.doif(() -> progress != null && cl.flip(), () -> progress.run((double)((Integer)consumed.get()).intValue() / (double)length));
            });
        }
        this.executor.shutdown();
        J.attempt(() -> this.executor.awaitTermination(100L, TimeUnit.HOURS));
    }

    static {
        IBootstrap.dasBoot();
    }
}

