/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.DOP;
import com.volmit.adapt.util.GBiset;
import com.volmit.adapt.util.VectorMath;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public enum Direction {
    U(0, 1, 0, Cuboid.CuboidDirection.Up),
    D(0, -1, 0, Cuboid.CuboidDirection.Down),
    N(0, 0, -1, Cuboid.CuboidDirection.North),
    S(0, 0, 1, Cuboid.CuboidDirection.South),
    E(1, 0, 0, Cuboid.CuboidDirection.East),
    W(-1, 0, 0, Cuboid.CuboidDirection.West);

    private static Map<GBiset<Direction, Direction>, DOP> permute;
    private final int x;
    private final int y;
    private final int z;
    private final Cuboid.CuboidDirection f;

    private Direction(int x, int y, int z, Cuboid.CuboidDirection f) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.f = f;
    }

    public static Direction getDirection(BlockFace f) {
        switch (f) {
            case DOWN: {
                return D;
            }
            case EAST: {
                return E;
            }
            case EAST_NORTH_EAST: {
                return E;
            }
            case EAST_SOUTH_EAST: {
                return E;
            }
            case NORTH: {
                return N;
            }
            case NORTH_EAST: {
                return N;
            }
            case NORTH_NORTH_EAST: {
                return N;
            }
            case NORTH_NORTH_WEST: {
                return N;
            }
            case NORTH_WEST: {
                return N;
            }
            case SELF: {
                return U;
            }
            case SOUTH: {
                return S;
            }
            case SOUTH_EAST: {
                return S;
            }
            case SOUTH_SOUTH_EAST: {
                return S;
            }
            case SOUTH_SOUTH_WEST: {
                return S;
            }
            case SOUTH_WEST: {
                return S;
            }
            case UP: {
                return U;
            }
            case WEST: {
                return W;
            }
            case WEST_NORTH_WEST: {
                return W;
            }
            case WEST_SOUTH_WEST: {
                return W;
            }
        }
        return D;
    }

    public static Direction closest(Vector v) {
        double m = Double.MAX_VALUE;
        Direction s = null;
        for (Direction i : Direction.values()) {
            Vector x = i.toVector();
            double g = x.dot(v);
            if (!(g < m)) continue;
            m = g;
            s = i;
        }
        return s;
    }

    public static Direction closest(Vector v, Direction ... d) {
        double m = Double.MAX_VALUE;
        Direction s = null;
        for (Direction i : d) {
            Vector x = i.toVector();
            double g = x.distance(v);
            if (!(g < m)) continue;
            m = g;
            s = i;
        }
        return s;
    }

    public static Direction closest(Vector v, List<Direction> d) {
        double m = Double.MAX_VALUE;
        Direction s = null;
        for (Direction i : d) {
            Vector x = i.toVector();
            double g = x.distance(v);
            if (!(g < m)) continue;
            m = g;
            s = i;
        }
        return s;
    }

    public static List<Direction> news() {
        ArrayList<Direction> d = new ArrayList<Direction>();
        XList.add(d, N, E, W, S);
        return d;
    }

    public static Direction getDirection(Vector v) {
        Vector k = VectorMath.triNormalize(v.clone().normalize());
        for (Direction i : Direction.udnews()) {
            if (i.x != k.getBlockX() || i.y != k.getBlockY() || i.z != k.getBlockZ()) continue;
            return i;
        }
        return N;
    }

    public static List<Direction> udnews() {
        ArrayList<Direction> d = new ArrayList<Direction>();
        XList.add(d, U, D, N, E, W, S);
        return d;
    }

    public static Direction fromByte(byte b) {
        if (b > 5 || b < 0) {
            return null;
        }
        if (b == 0) {
            return D;
        }
        if (b == 1) {
            return U;
        }
        if (b == 2) {
            return N;
        }
        if (b == 3) {
            return S;
        }
        if (b == 4) {
            return W;
        }
        return E;
    }

    public static void calculatePermutations() {
        if (permute != null) {
            return;
        }
        permute = new HashMap<GBiset<Direction, Direction>, DOP>();
        for (Direction i : Direction.udnews()) {
            for (Direction j : Direction.udnews()) {
                GBiset<Direction, Direction> b = new GBiset<Direction, Direction>(i, j);
                if (i.equals((Object)j)) {
                    permute.put(b, new DOP("DIRECT"){

                        @Override
                        public Vector op(Vector v) {
                            return v;
                        }
                    });
                    continue;
                }
                if (i.reverse().equals((Object)j)) {
                    if (i.isVertical()) {
                        permute.put(b, new DOP("R180CCZ"){

                            @Override
                            public Vector op(Vector v) {
                                return VectorMath.rotate90CCZ(VectorMath.rotate90CCZ(v));
                            }
                        });
                        continue;
                    }
                    permute.put(b, new DOP("R180CCY"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CCY(VectorMath.rotate90CCY(v));
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CX(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CX"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CX(v);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCX(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CCX"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CCX(v);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CY(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CY"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CY(v);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCY(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CCY"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CCY(v);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CZ(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CZ"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CZ(v);
                        }
                    });
                    continue;
                }
                if (Direction.getDirection(VectorMath.rotate90CCZ(i.toVector())).equals((Object)j)) {
                    permute.put(b, new DOP("R90CCZ"){

                        @Override
                        public Vector op(Vector v) {
                            return VectorMath.rotate90CCZ(v);
                        }
                    });
                    continue;
                }
                permute.put(b, new DOP("FAIL"){

                    @Override
                    public Vector op(Vector v) {
                        return v;
                    }
                });
            }
        }
    }

    public String toString() {
        switch (this) {
            case D: {
                return "Down";
            }
            case E: {
                return "East";
            }
            case N: {
                return "North";
            }
            case S: {
                return "South";
            }
            case U: {
                return "Up";
            }
            case W: {
                return "West";
            }
        }
        return "?";
    }

    public boolean isVertical() {
        return this.equals((Object)D) || this.equals((Object)U);
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public boolean isCrooked(Direction to) {
        if (this.equals((Object)to.reverse())) {
            return false;
        }
        return !this.equals((Object)to);
    }

    public Vector angle(Vector initial, Direction d) {
        Direction.calculatePermutations();
        for (GBiset<Direction, Direction> i : permute.keySet()) {
            if (!i.getA().equals((Object)this) || !i.getB().equals((Object)d)) continue;
            return permute.get(i).op(initial);
        }
        return initial;
    }

    public Direction reverse() {
        switch (this) {
            case D: {
                return U;
            }
            case E: {
                return W;
            }
            case N: {
                return S;
            }
            case S: {
                return N;
            }
            case U: {
                return D;
            }
            case W: {
                return E;
            }
        }
        return null;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Cuboid.CuboidDirection f() {
        return this.f;
    }

    public byte byteValue() {
        switch (this) {
            case D: {
                return 0;
            }
            case E: {
                return 5;
            }
            case N: {
                return 2;
            }
            case S: {
                return 3;
            }
            case U: {
                return 1;
            }
            case W: {
                return 4;
            }
        }
        return -1;
    }

    public BlockFace getFace() {
        switch (this) {
            case D: {
                return BlockFace.DOWN;
            }
            case E: {
                return BlockFace.EAST;
            }
            case N: {
                return BlockFace.NORTH;
            }
            case S: {
                return BlockFace.SOUTH;
            }
            case U: {
                return BlockFace.UP;
            }
            case W: {
                return BlockFace.WEST;
            }
        }
        return null;
    }

    public Axis getAxis() {
        switch (this) {
            case D: {
                return Axis.Y;
            }
            case E: {
                return Axis.X;
            }
            case N: {
                return Axis.Z;
            }
            case S: {
                return Axis.Z;
            }
            case U: {
                return Axis.Y;
            }
            case W: {
                return Axis.X;
            }
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
        permute = null;
    }
}

