/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.J;
import com.volmit.adapt.util.NastyRunnable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class GroupedExecutor {
    private final ExecutorService service;
    private final Map<String, Integer> mirror = new HashMap<String, Integer>();
    private int xc = 1;

    public GroupedExecutor(int threadLimit, final int priority, final String name) {
        if (threadLimit == 1) {
            this.service = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setName(name);
                t.setPriority(priority);
                return t;
            });
        } else if (threadLimit > 1) {
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                    ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    worker.setName(name + " " + GroupedExecutor.this.xc++);
                    worker.setPriority(priority);
                    return worker;
                }
            };
            this.service = new ForkJoinPool(threadLimit, factory, null, false);
        } else {
            this.service = Executors.newCachedThreadPool(r -> {
                Thread t = new Thread(r);
                t.setName(name + " " + this.xc++);
                t.setPriority(priority);
                return t;
            });
        }
    }

    public void waitFor(String g) {
        if (g == null) {
            return;
        }
        if (!this.mirror.containsKey(g)) {
            return;
        }
        while (this.mirror.get(g) != 0) {
        }
    }

    public void queue(String q, NastyRunnable r) {
        this.mirror.compute(q, (k, v) -> k == null || v == null ? 1 : v + 1);
        this.service.execute(() -> {
            try {
                r.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.mirror.compute(q, (k, v) -> v - 1);
        });
    }

    public void close() {
        J.a(() -> {
            J.sleep(100L);
            this.service.shutdown();
        });
    }

    public void closeNow() {
        this.service.shutdown();
    }

    static {
        IBootstrap.dasBoot();
    }
}

