/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarScanner {
    private final Set<Class<?>> classes;
    private final File jar;
    private final String superPackage;

    public JarScanner(File jar, String superPackage) {
        this.jar = jar;
        this.classes = new HashSet();
        this.superPackage = superPackage;
    }

    public void scan() throws IOException {
        this.classes.clear();
        FileInputStream fin = new FileInputStream(this.jar);
        ZipInputStream zip = new ZipInputStream(fin);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            String c;
            if (!entry.isDirectory() && entry.getName().endsWith(".class") && !entry.getName().contains("$") && (c = entry.getName().replaceAll("/", ".").replace(".class", "")).startsWith(this.superPackage)) {
                try {
                    Class<?> clazz = Class.forName(c);
                    this.classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            entry = zip.getNextEntry();
        }
        zip.close();
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public File getJar() {
        return this.jar;
    }

    static {
        IBootstrap.dasBoot();
    }
}

