/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Dictionary;
import com.volmit.adapt.util.JSONArray;
import com.volmit.adapt.util.JSONException;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class JsonCompressor {
    private static final String escapeChar = ";";
    private static final int ESCAPED_UPPERCASE = 1;
    private static final int USE_PROTOTYPE = 4;
    String aWalk;
    int pos = 0;
    private String prototypeCompact;

    public JsonCompressor() {
    }

    public JsonCompressor(String prototype) {
        if (prototype != null) {
            this.prototypeCompact = this.compact(prototype);
        }
    }

    public byte[] compressJson(String json) {
        byte[] compress;
        int options = 0;
        String walkFormat = this.walkFormat(json);
        String tickedString = walkFormat.replaceAll("([A-Z])", ";$1");
        String upperTickedString = tickedString.toUpperCase();
        upperTickedString = Dictionary.shorten(upperTickedString);
        byte[] compressEscapedCase = this.compress6AndDec(upperTickedString.getBytes());
        byte[] compressUnescapedCase = this.pack(walkFormat.getBytes(), 7);
        byte[] deflated = null;
        if (this.prototypeCompact != null) {
            deflated = this.deflateWithPrototype(upperTickedString);
        }
        if (deflated != null && deflated.length < compressEscapedCase.length) {
            compress = deflated;
            options |= 1;
            options |= 4;
        } else if (compressEscapedCase.length < compressUnescapedCase.length) {
            compress = compressEscapedCase;
            options |= 1;
        } else {
            compress = compressUnescapedCase;
        }
        byte[] bytesWithOptions = new byte[compress.length + 1];
        bytesWithOptions[0] = (byte)options;
        System.arraycopy(compress, 0, bytesWithOptions, 1, compress.length);
        return bytesWithOptions;
    }

    public String expandJson(byte[] bytesWithOptions) {
        String expandedString;
        byte options = bytesWithOptions[0];
        byte[] bytes = new byte[bytesWithOptions.length - 1];
        System.arraycopy(bytesWithOptions, 1, bytes, 0, bytesWithOptions.length - 1);
        if ((options & 1) != 0) {
            if ((options & 4) != 0) {
                if (this.prototypeCompact == null) {
                    throw new RuntimeException("Unable to expand. Do not have the prototype.");
                }
                expandedString = this.inflateWithPrototype(bytes);
            } else {
                expandedString = new String(this.expand6AndInc(bytes));
            }
            expandedString = Dictionary.lengthen(expandedString);
            expandedString = expandedString.toLowerCase();
            for (char a2 : "abcdefghijklmnopqrstuvwxyz".toCharArray()) {
                expandedString = expandedString.replaceAll(escapeChar + a2, ("" + a2).toUpperCase());
            }
        } else {
            expandedString = new String(this.unpack(bytes, 7));
        }
        return this.unwalkFormat(expandedString);
    }

    void incrementEach(byte[] bytes, int inc) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] + inc);
        }
    }

    byte[] expand6AndInc(byte[] sourceBytes) {
        byte[] expanded = this.unpack(sourceBytes, 6);
        this.incrementEach(expanded, 32);
        return expanded;
    }

    byte[] compress6AndDec(byte[] sourceBytes) {
        this.incrementEach(sourceBytes, -32);
        return this.pack(sourceBytes, 6);
    }

    byte[] unpack(byte[] sourceBytes, int bits) {
        byte[] resultBytes = new byte[sourceBytes.length * 8 / bits];
        int offset = 0;
        int mask = 0;
        if (bits == 6) {
            mask = 63;
        } else if (bits == 7) {
            mask = 127;
        } else {
            throw new RuntimeException("Can only unpack 6 or 7 bits");
        }
        int indent = 8 - bits;
        for (int i = 0; i < resultBytes.length; ++i) {
            int into = offset & 7;
            int byteNo = offset >> 3;
            int source = 0xFF & sourceBytes[byteNo];
            if (into == 0) {
                resultBytes[i] = (byte)(source >> indent);
            } else if (into <= indent) {
                resultBytes[i] = (byte)(mask & source);
            } else {
                byte firstByte = (byte)(mask & source << into - indent);
                byte secondByte = (byte)((0xFF & sourceBytes[byteNo + 1]) >> 16 - bits - into);
                resultBytes[i] = (byte)(firstByte | secondByte);
            }
            offset += bits;
        }
        if (resultBytes.length > 0 && resultBytes[resultBytes.length - 1] == 0) {
            byte[] trimmed = new byte[resultBytes.length - 1];
            System.arraycopy(resultBytes, 0, trimmed, 0, trimmed.length);
            resultBytes = trimmed;
        }
        return resultBytes;
    }

    byte[] pack(byte[] sourceBytes, int bits) {
        int resultLength = sourceBytes.length * bits / 8;
        if (resultLength * 8 < sourceBytes.length * bits) {
            ++resultLength;
        }
        byte[] resultBytes = new byte[resultLength];
        int offset = 0;
        for (int i = 0; i < resultBytes.length; ++i) {
            resultBytes[i] = 0;
        }
        int indent = 8 - bits;
        for (int i = 0; i < sourceBytes.length; ++i) {
            byte source = sourceBytes[i];
            int into = offset & 7;
            int byteNo = offset >> 3;
            if (into == 0) {
                resultBytes[byteNo] = (byte)(0xFF & source << indent);
            } else if (into <= indent) {
                resultBytes[byteNo] = (byte)(resultBytes[byteNo] | source);
            } else {
                resultBytes[byteNo] = (byte)(resultBytes[byteNo] | source >> into - indent);
                resultBytes[byteNo + 1] = (byte)(0xFF & source << 16 - bits - into);
            }
            offset += bits;
        }
        return resultBytes;
    }

    byte[] deflateWithPrototype(String sCompact) {
        byte[] output = new byte[100];
        Deflater compresser = new Deflater();
        compresser.setDictionary(this.prototypeCompact.getBytes());
        compresser.setInput(sCompact.getBytes());
        compresser.finish();
        int compressedDataLength = compresser.deflate(output);
        compresser.end();
        byte[] result = new byte[compressedDataLength];
        System.arraycopy(output, 0, result, 0, compressedDataLength);
        return result;
    }

    String inflateWithPrototype(byte[] deflated) {
        Inflater inflater = new Inflater();
        inflater.setInput(deflated, 0, deflated.length);
        byte[] result = new byte[400];
        int resultLength = 0;
        try {
            inflater.inflate(result);
            inflater.setDictionary(this.prototypeCompact.getBytes());
            resultLength = inflater.inflate(result);
            if (resultLength == result.length) {
                throw new RuntimeException("Unable to expand. Too little space");
            }
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException("Unable to expand from prototype", dfe);
        }
        inflater.end();
        return new String(result, 0, resultLength);
    }

    private String compact(String s) {
        String json = this.normalizeJson(s);
        String walkFormat = this.walkFormat(json);
        String tickedString = walkFormat.replaceAll("([A-Z])", ";$1");
        String upperTickedString = tickedString.toUpperCase();
        return Dictionary.shorten(upperTickedString);
    }

    private String normalizeJson(String s) {
        return new JSONObject(s).toString();
    }

    String walkFormat(String json) {
        String s = json.trim();
        StringBuilder sb = new StringBuilder();
        char[] chars = s.toCharArray();
        boolean inString = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                inString = !inString;
                continue;
            }
            if (c == '>' && inString) {
                sb.append(";>");
                continue;
            }
            if (c == '+' && inString) {
                sb.append(";+");
                continue;
            }
            if (c == '^' && inString) {
                sb.append(";^");
                continue;
            }
            if (c == '*' && inString) {
                sb.append(";*");
                continue;
            }
            if (c == '<' && inString) {
                sb.append(";<");
                continue;
            }
            if (c == ';' && inString) {
                sb.append(";;");
                continue;
            }
            if (c == ' ' && !inString || c == '\n' && !inString) continue;
            if (c == '}' && !inString) {
                sb.append('^');
                continue;
            }
            if (c == ']' && !inString) {
                sb.append('^');
                continue;
            }
            if (c == '{' && !inString) {
                sb.append('+');
                continue;
            }
            if (c == '[' && !inString) {
                sb.append('*');
                continue;
            }
            if (c == ',' && !inString) {
                sb.append('>');
                continue;
            }
            if (c == ':' && !inString) {
                sb.append('>');
                continue;
            }
            sb.append(c);
        }
        String s1 = sb.toString();
        if (s1.startsWith("+")) {
            s1 = s1.substring(1);
        }
        while (s1.endsWith("^")) {
            s1 = s1.substring(0, s1.length() - 1);
        }
        return s1;
    }

    String unwalkFormat(String walk) {
        this.aWalk = walk;
        if (!this.aWalk.startsWith("*")) {
            this.aWalk = "+" + this.aWalk + "^";
        }
        this.pos = 0;
        Object jsonObject = null;
        try {
            jsonObject = this.readWalk();
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't parse walk", e);
        }
        return jsonObject.toString();
    }

    Object readWalk() throws JSONException {
        char c = this.aWalk.charAt(this.pos);
        if (c == '+') {
            ++this.pos;
            return this.readMap();
        }
        if (c == '*') {
            ++this.pos;
            return this.readArray();
        }
        return this.readString();
    }

    JSONObject readMap() throws JSONException {
        char c = this.aWalk.charAt(this.pos);
        JSONObject result = new JSONObject();
        while (this.pos < this.aWalk.length() && c != '^') {
            String key = this.readString();
            if ((c = this.aWalk.charAt(++this.pos)) == '>') {
                ++this.pos;
            }
            Object value = this.readWalk();
            result.put(key, value);
            if (this.pos == this.aWalk.length() - 1) break;
            if ((c = this.aWalk.charAt(++this.pos)) != '>') continue;
            ++this.pos;
        }
        return result;
    }

    JSONArray readArray() throws JSONException {
        char c = this.aWalk.charAt(this.pos);
        JSONArray result = new JSONArray();
        while (this.pos < this.aWalk.length() && c != '^') {
            Object value = this.readWalk();
            result.put(value);
            if (this.pos == this.aWalk.length() - 1) break;
            if ((c = this.aWalk.charAt(++this.pos)) != '>') continue;
            ++this.pos;
        }
        return result;
    }

    String readString() {
        StringBuilder sb = new StringBuilder();
        char c = this.aWalk.charAt(this.pos);
        int start = this.pos;
        boolean escaped = false;
        while (escaped || c != '^' && c != '>' && c != '+' && c != '*') {
            boolean atEscape;
            boolean bl = atEscape = c == escapeChar.charAt(0);
            if (!escaped && atEscape) {
                escaped = true;
            } else {
                escaped = false;
                sb.append(c);
            }
            if (this.pos == this.aWalk.length() - 1) {
                ++this.pos;
                break;
            }
            c = this.aWalk.charAt(++this.pos);
        }
        --this.pos;
        return sb.toString();
    }

    static {
        IBootstrap.dasBoot();
    }
}

