/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class MaterialBlock {
    private Material material;
    private Byte data;

    public MaterialBlock(Material material, Byte data) {
        this.material = material;
        this.data = data;
    }

    public MaterialBlock(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialBlock(Location location) {
        this(location.getBlock());
    }

    public MaterialBlock(BlockState state) {
        this.material = state.getType();
        this.data = state.getData().getData();
    }

    public MaterialBlock(Block block) {
        this.material = block.getType();
        this.data = block.getData();
    }

    public MaterialBlock() {
        this.material = Material.AIR;
        this.data = 0;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Byte getData() {
        return this.data;
    }

    public void setData(Byte data) {
        this.data = data;
    }

    public String toString() {
        if (this.getData() == 0) {
            return this.getMaterial().toString();
        }
        return this.getMaterial().toString() + ":" + this.getData();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialBlock other = (MaterialBlock)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return this.material == other.material;
    }

    static {
        IBootstrap.dasBoot();
    }
}

