/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Command;
import com.volmit.adapt.util.ICommand;
import com.volmit.adapt.util.MortarPermission;
import com.volmit.adapt.util.MortarSender;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Sound;

public abstract class MortarCommand
implements ICommand {
    private final List<MortarCommand> children;
    private final List<String> nodes;
    private final List<String> requiredPermissions;
    private final String node;
    private String category = "";
    private String description;

    public MortarCommand(String node, String ... nodes) {
        this.node = node;
        this.nodes = new ArrayList<String>();
        XList.add(this.nodes, nodes);
        this.requiredPermissions = new ArrayList<String>();
        this.children = this.buildChildren();
        this.description = "No Description";
    }

    @Override
    public List<String> handleTab(MortarSender sender, String[] args) {
        ArrayList<String> v = new ArrayList<String>();
        if (args.length == 0) {
            for (MortarCommand i : this.getChildren()) {
                v.add(i.getNode());
            }
        }
        this.addTabOptions(sender, args, v);
        if (v.isEmpty()) {
            return null;
        }
        if (sender.isPlayer()) {
            sender.player().getWorld().playSound(sender.player().getLocation(), Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, 0.25f, 1.7f);
        }
        return v;
    }

    public abstract void addTabOptions(MortarSender var1, String[] var2, List<String> var3);

    public void printHelp(MortarSender sender) {
        boolean b = false;
        for (MortarCommand i : this.getChildren()) {
            for (String j : i.getRequiredPermissions()) {
                if (sender.hasPermission(j)) continue;
            }
            b = true;
            sender.sendMessage(C.GREEN + i.getNode() + " " + C.WHITE + i.getArgsUsage() + C.GRAY + " - " + i.getDescription());
        }
        if (!b) {
            sender.sendMessage("There are either no sub-commands or you do not have permission to use them.");
        }
        if (sender.isPlayer()) {
            sender.player().getWorld().playSound(sender.player().getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.28f, 1.4f);
            sender.player().getWorld().playSound(sender.player().getLocation(), Sound.ITEM_AXE_STRIP, 0.35f, 1.7f);
        }
    }

    protected abstract String getArgsUsage();

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void requiresPermission(MortarPermission node) {
        if (node == null) {
            return;
        }
        this.requiresPermission(node.toString());
    }

    protected void requiresPermission(String node) {
        if (node == null) {
            return;
        }
        this.requiredPermissions.add(node);
    }

    public void rejectAny(int past, MortarSender sender, String[] a2) {
        if (a2.length > past) {
            int p = past;
            Object m = "";
            for (String i : a2) {
                if (--p >= 0) continue;
                m = (String)m + i + ", ";
            }
            if (!((String)m).trim().isEmpty()) {
                sender.sendMessage("Parameters Ignored: " + (String)m);
            }
        }
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public List<String> getNodes() {
        return this.nodes;
    }

    @Override
    public List<String> getAllNodes() {
        return XList.qadd(XList.copy(this.getNodes()), this.getNode());
    }

    @Override
    public void addNode(String node) {
        this.getNodes().add(node);
    }

    public List<MortarCommand> getChildren() {
        return this.children;
    }

    private List<MortarCommand> buildChildren() {
        ArrayList<MortarCommand> p = new ArrayList<MortarCommand>();
        for (Field i : this.getClass().getDeclaredFields()) {
            if (!i.isAnnotationPresent(Command.class)) continue;
            try {
                i.setAccessible(true);
                MortarCommand pc = (MortarCommand)i.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
                Command c = i.getAnnotation(Command.class);
                if (!c.value().trim().isEmpty()) {
                    pc.setCategory(c.value().trim());
                } else {
                    pc.setCategory(this.getCategory());
                }
                p.add(pc);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    @Override
    public List<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    static {
        IBootstrap.dasBoot();
    }
}

