/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.BurstExecutor;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MultiBurst {
    public static MultiBurst burst;
    private final ExecutorService service;
    private int tid;

    public MultiBurst(int tc) {
        this.service = Executors.newFixedThreadPool(tc, r -> {
            ++this.tid;
            Thread t = new Thread(r);
            t.setName("Adapt Workgroup " + this.tid);
            t.setPriority(10);
            t.setUncaughtExceptionHandler((et, e) -> {
                Adapt.info("Exception encountered in " + et.getName());
                e.printStackTrace();
            });
            return t;
        });
    }

    public void burst(Runnable ... r) {
        this.burst(r.length).queue(r).complete();
    }

    public void sync(Runnable ... r) {
        for (Runnable i : r) {
            i.run();
        }
    }

    public BurstExecutor burst(int estimate) {
        return new BurstExecutor(this.service, estimate);
    }

    public BurstExecutor burst() {
        return this.burst(16);
    }

    public void lazy(Runnable o) {
        this.service.execute(o);
    }

    public ExecutorService getService() {
        return this.service;
    }

    static {
        IBootstrap.dasBoot();
        burst = new MultiBurst(Runtime.getRuntime().availableProcessors());
    }
}

