/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Writable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.StringJoiner;

public class NibbleArray
implements Writable {
    private static final int[] MASKS;
    private final int size;
    private final Object lock = new Object();
    private byte[] data;
    private int depth;
    private byte mask;
    private transient int bitIndex;
    private transient int byteIndex;
    private transient int bitInByte;

    public NibbleArray(int capacity, DataInputStream in) throws IOException {
        this.size = capacity;
        this.read(in);
    }

    public NibbleArray(int nibbleDepth, int capacity) {
        if (nibbleDepth > 8 || nibbleDepth < 1) {
            throw new IllegalArgumentException();
        }
        int neededBits = nibbleDepth * capacity;
        this.size = capacity;
        this.depth = nibbleDepth;
        this.data = new byte[(neededBits + neededBits % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(nibbleDepth);
    }

    public NibbleArray(int nibbleDepth, int capacity, NibbleArray existing) {
        if (nibbleDepth > 8 || nibbleDepth < 1) {
            throw new IllegalArgumentException();
        }
        int neededBits = nibbleDepth * capacity;
        this.size = capacity;
        this.depth = nibbleDepth;
        this.data = new byte[(neededBits + neededBits % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(nibbleDepth);
        for (int i = 0; i < Math.min(this.size, existing.size()); ++i) {
            this.set(i, existing.get(i));
        }
    }

    public static int maskFor(int amountOfBits) {
        return NibbleArray.powerOfTwo(amountOfBits) - 1;
    }

    public static int powerOfTwo(int power) {
        int result = 1;
        for (int i = 0; i < power; ++i) {
            result *= 2;
        }
        return result;
    }

    public static String binaryString(byte b, ByteOrder byteOrder) {
        String str = String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
        return byteOrder.equals(ByteOrder.BIG_ENDIAN) ? str : NibbleArray.reverse(str);
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    @Override
    public void write(DataOutputStream o) throws IOException {
        o.writeByte(this.depth + -128);
        o.write(this.data);
    }

    @Override
    public void read(DataInputStream i) throws IOException {
        this.depth = i.readByte() - -128;
        int neededBits = this.depth * this.size;
        this.data = new byte[(neededBits + neededBits % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(this.depth);
        i.read(this.data);
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get(int index) {
        Object object = this.lock;
        synchronized (object) {
            this.bitIndex = index * this.depth;
            this.byteIndex = this.bitIndex >> 3;
            this.bitInByte = this.bitIndex & 7;
            int value = this.data[this.byteIndex] >> this.bitInByte;
            if (this.bitInByte + this.depth > 8) {
                value |= this.data[this.byteIndex + 1] << this.bitInByte;
            }
            return (byte)(value & this.mask);
        }
    }

    public byte getAsync(int index) {
        int bitIndex = index * this.depth;
        int byteIndex = bitIndex >> 3;
        int bitInByte = bitIndex & 7;
        int value = this.data[byteIndex] >> bitInByte;
        if (bitInByte + this.depth > 8) {
            value |= this.data[byteIndex + 1] << bitInByte;
        }
        return (byte)(value & this.mask);
    }

    public void set(int index, int nibble) {
        this.set(index, (byte)nibble);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int index, byte nybble) {
        Object object = this.lock;
        synchronized (object) {
            this.bitIndex = index * this.depth;
            this.byteIndex = this.bitIndex >> 3;
            this.bitInByte = this.bitIndex & 7;
            this.data[this.byteIndex] = (byte)((~(this.data[this.byteIndex] & this.mask << this.bitInByte) & this.data[this.byteIndex] | (nybble & this.mask) << this.bitInByte) & 0xFF);
            if (this.bitInByte + this.depth > 8) {
                this.data[this.byteIndex + 1] = (byte)((~(this.data[this.byteIndex + 1] & MASKS[this.bitInByte + this.depth - 8]) & this.data[this.byteIndex + 1] | (nybble & this.mask) >> 8 - this.bitInByte) & 0xFF);
            }
        }
    }

    public String toBitsString() {
        return this.toBitsString(ByteOrder.BIG_ENDIAN);
    }

    public String toBitsString(ByteOrder byteOrder) {
        StringJoiner joiner = new StringJoiner(" ");
        for (int i = 0; i < this.data.length; ++i) {
            joiner.add(NibbleArray.binaryString(this.data[i], byteOrder));
        }
        return joiner.toString();
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
    }

    public void setAll(byte nibble) {
        for (int i = 0; i < this.size; ++i) {
            this.set(i, nibble);
        }
    }

    public void setAll(int nibble) {
        for (int i = 0; i < this.size; ++i) {
            this.set(i, (byte)nibble);
        }
    }

    static {
        IBootstrap.dasBoot();
        MASKS = new int[8];
        for (int i = 0; i < MASKS.length; ++i) {
            NibbleArray.MASKS[i] = NibbleArray.maskFor(i);
        }
    }
}

