/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.FastReflection;
import com.volmit.adapt.util.ParticleSender;
import com.volmit.adapt.util.ParticleType;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

class ParticleSenderLegacy
implements ParticleSender {
    private static final boolean SERVER_IS_1_8;
    private static final Constructor<?> PACKET_PARTICLE;
    private static final Class<?> ENUM_PARTICLE;
    private static final Method WORLD_GET_HANDLE;
    private static final Method WORLD_SEND_PARTICLE;
    private static final Method PLAYER_GET_HANDLE;
    private static final Field PLAYER_CONNECTION;
    private static final Method SEND_PACKET;
    private static final int[] EMPTY;

    ParticleSenderLegacy() {
    }

    @Override
    public void spawnParticle(Object receiver, ParticleType particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        try {
            int[] datas = this.toData(particle, data);
            if (data instanceof Color && particle.getDataType() == Color.class) {
                Color color = (Color)data;
                count = 0;
                offsetX = this.color(color.getRed());
                offsetY = this.color(color.getGreen());
                offsetZ = this.color(color.getBlue());
                extra = 1.0;
            }
            if (receiver instanceof World) {
                Object worldServer = WORLD_GET_HANDLE.invoke(receiver, new Object[0]);
                if (SERVER_IS_1_8) {
                    WORLD_SEND_PARTICLE.invoke(worldServer, null, this.getEnumParticle(particle), true, x, y, z, count, offsetX, offsetY, offsetZ, extra, datas);
                } else {
                    String particleName = particle.getLegacyName() + (String)(datas.length != 2 ? "" : "_" + datas[0] + "_" + datas[1]);
                    WORLD_SEND_PARTICLE.invoke(worldServer, particleName, x, y, z, count, offsetX, offsetY, offsetZ, extra);
                }
            } else if (receiver instanceof Player) {
                Object packet;
                if (SERVER_IS_1_8) {
                    packet = PACKET_PARTICLE.newInstance(this.getEnumParticle(particle), true, Float.valueOf((float)x), Float.valueOf((float)y), Float.valueOf((float)z), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)extra), count, datas);
                } else {
                    String particleName = particle.getLegacyName() + (String)(datas.length != 2 ? "" : "_" + datas[0] + "_" + datas[1]);
                    packet = PACKET_PARTICLE.newInstance(particleName, Float.valueOf((float)x), Float.valueOf((float)y), Float.valueOf((float)z), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)extra), count);
                }
                Object entityPlayer = PLAYER_GET_HANDLE.invoke(receiver, new Object[0]);
                Object playerConnection = PLAYER_CONNECTION.get(entityPlayer);
                SEND_PACKET.invoke(playerConnection, packet);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isValidData(Object particle, Object data) {
        return true;
    }

    @Override
    public Object getParticle(ParticleType particle) {
        if (!SERVER_IS_1_8) {
            return particle.getLegacyName();
        }
        try {
            return this.getEnumParticle(particle);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private Object getEnumParticle(ParticleType particleType) {
        return FastReflection.enumValueOf(ENUM_PARTICLE, particleType.toString());
    }

    private int[] toData(ParticleType particle, Object data) {
        Class<?> dataType = particle.getDataType();
        if (dataType == ItemStack.class) {
            if (!(data instanceof ItemStack)) {
                int[] nArray;
                if (SERVER_IS_1_8) {
                    nArray = new int[2];
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 1;
                    nArray = nArray2;
                    nArray2[1] = 0;
                }
                return nArray;
            }
            ItemStack itemStack = (ItemStack)data;
            return new int[]{itemStack.getType().getId(), itemStack.getDurability()};
        }
        if (dataType == MaterialData.class) {
            if (!(data instanceof MaterialData)) {
                int[] nArray;
                if (SERVER_IS_1_8) {
                    nArray = new int[1];
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 1;
                    nArray = nArray3;
                    nArray3[1] = 0;
                }
                return nArray;
            }
            MaterialData materialData = (MaterialData)data;
            if (SERVER_IS_1_8) {
                return new int[]{materialData.getItemType().getId() + (materialData.getData() << 12)};
            }
            return new int[]{materialData.getItemType().getId(), materialData.getData()};
        }
        return EMPTY;
    }

    static {
        IBootstrap.dasBoot();
        EMPTY = new int[0];
        ENUM_PARTICLE = FastReflection.nmsOptionalClass("EnumParticle").orElse(null);
        SERVER_IS_1_8 = ENUM_PARTICLE != null;
        try {
            Class<?> packetParticleClass = FastReflection.nmsClass("PacketPlayOutWorldParticles");
            Class<?> playerClass = FastReflection.nmsClass("EntityPlayer");
            Class<?> playerConnectionClass = FastReflection.nmsClass("PlayerConnection");
            Class<?> worldClass = FastReflection.nmsClass("WorldServer");
            Class<?> entityPlayerClass = FastReflection.nmsClass("EntityPlayer");
            Class<?> craftPlayerClass = FastReflection.obcClass("entity.CraftPlayer");
            Class<?> craftWorldClass = FastReflection.obcClass("CraftWorld");
            if (SERVER_IS_1_8) {
                PACKET_PARTICLE = packetParticleClass.getConstructor(ENUM_PARTICLE, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
                WORLD_SEND_PARTICLE = worldClass.getDeclaredMethod("sendParticles", entityPlayerClass, ENUM_PARTICLE, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, int[].class);
            } else {
                PACKET_PARTICLE = packetParticleClass.getConstructor(String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
                WORLD_SEND_PARTICLE = worldClass.getDeclaredMethod("a", String.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            }
            WORLD_GET_HANDLE = craftWorldClass.getDeclaredMethod("getHandle", new Class[0]);
            PLAYER_GET_HANDLE = craftPlayerClass.getDeclaredMethod("getHandle", new Class[0]);
            PLAYER_CONNECTION = playerClass.getField("playerConnection");
            SEND_PACKET = playerConnectionClass.getMethod("sendPacket", FastReflection.nmsClass("Packet"));
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

