/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;

public class RNG
extends Random {
    public static final RNG r;
    private static final char[] CHARGEN;
    private static final long serialVersionUID = 5222938581174415179L;
    private final long sx;

    public RNG() {
        this.sx = 0L;
    }

    public RNG(long seed) {
        super(seed);
        this.sx = seed;
    }

    public RNG(String seed) {
        this(UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).getLeastSignificantBits() + UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8)).getMostSignificantBits() + (long)(seed.length() * 32564));
    }

    public RNG nextParallelRNG(int signature) {
        return new RNG(this.sx + (long)signature);
    }

    public RNG nextParallelRNG(long signature) {
        return new RNG(this.sx + signature);
    }

    public RNG nextRNG() {
        return new RNG(this.nextLong());
    }

    public String s(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(this.c());
        }
        return sb.toString();
    }

    public char c() {
        return CHARGEN[this.i(CHARGEN.length - 1)];
    }

    public <T> T e(Class<T> t) {
        T[] c = t.getEnumConstants();
        return c[this.i(c.length)];
    }

    public boolean b() {
        return this.nextBoolean();
    }

    public boolean b(double percent) {
        return this.d() > percent;
    }

    public short si(int lowerBound, int upperBound) {
        return (short)((float)lowerBound + this.nextFloat() * (float)(upperBound - lowerBound + 1));
    }

    public short si(int upperBound) {
        return this.si(0, upperBound);
    }

    public short si() {
        return this.si(1);
    }

    public float f(float lowerBound, float upperBound) {
        return lowerBound + this.nextFloat() * (upperBound - lowerBound);
    }

    public float f(float upperBound) {
        return this.f(0.0f, upperBound);
    }

    public float f() {
        return this.f(1.0f);
    }

    public double d(double lowerBound, double upperBound) {
        return M.lerp(lowerBound, upperBound, this.nextDouble());
    }

    public double d(double upperBound) {
        return this.d(0.0, upperBound);
    }

    public double d() {
        return this.d(1.0);
    }

    public int i(int lowerBound, int upperBound) {
        return (int)Math.round(this.d(lowerBound, upperBound));
    }

    public int i(int upperBound) {
        return this.i(Math.min(upperBound, 0), Math.max(0, upperBound));
    }

    public long l(long lowerBound, long upperBound) {
        return Math.round(this.d(lowerBound, upperBound));
    }

    public long l(long upperBound) {
        return this.l(0L, upperBound);
    }

    public int imax() {
        return this.i(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public long lmax() {
        return this.l(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public float fmax() {
        return this.f(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public double dmax() {
        return this.d(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public short simax() {
        return this.si(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public boolean chance(double chance) {
        return chance >= this.nextDouble();
    }

    static {
        IBootstrap.dasBoot();
        r = new RNG();
        CHARGEN = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-=!@#$%^&*()_+`~[];',./<>?:\\\"{}|\\\\".toCharArray();
    }
}

